/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.erlang.connection;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.erlang.OtpIOException;
import org.springframework.erlang.connection.Connection;
import org.springframework.erlang.connection.ConnectionFactory;
import org.springframework.erlang.connection.DefaultConnection;
import org.springframework.util.Assert;

public class SingleConnectionFactory
implements ConnectionFactory,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean uniqueSelfNodeName = true;
    private String selfNodeName;
    private String cookie;
    private String peerNodeName;
    private OtpSelf otpSelf;
    private OtpPeer otpPeer;
    private Connection targetConnection;
    private Connection connection;
    private final Object connectionMonitor = new Object();

    public SingleConnectionFactory(String selfNodeName, String cookie, String peerNodeName) {
        this.selfNodeName = selfNodeName;
        this.cookie = cookie;
        this.peerNodeName = peerNodeName;
    }

    public SingleConnectionFactory(String selfNodeName, String peerNodeName) {
        this.selfNodeName = selfNodeName;
        this.peerNodeName = peerNodeName;
    }

    public boolean isUniqueSelfNodeName() {
        return this.uniqueSelfNodeName;
    }

    public void setUniqueSelfNodeName(boolean uniqueSelfNodeName) {
        this.uniqueSelfNodeName = uniqueSelfNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws UnknownHostException, OtpAuthException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                try {
                    this.initConnection();
                }
                catch (IOException e) {
                    throw new OtpIOException("failed to connect from '" + this.selfNodeName + "' to peer node '" + this.peerNodeName + "'", e);
                }
            }
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws IOException, OtpAuthException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.targetConnection != null) {
                this.closeConnection(this.targetConnection);
            }
            this.targetConnection = this.doCreateConnection();
            this.prepareConnection(this.targetConnection);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Established shared Rabbit Connection: " + this.targetConnection));
            }
            this.connection = this.getSharedConnectionProxy(this.targetConnection);
        }
    }

    public void destroy() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.targetConnection != null) {
                this.closeConnection(this.targetConnection);
            }
            this.targetConnection = null;
            this.connection = null;
        }
    }

    protected void closeConnection(Connection connection) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing shared Rabbit Connection: " + this.targetConnection));
        }
        try {
            connection.close();
        }
        catch (Throwable ex) {
            this.logger.debug((Object)"Could not close shared Rabbit Connection", ex);
        }
    }

    protected Connection doCreateConnection() throws IOException, OtpAuthException {
        return new DefaultConnection(this.otpSelf.connect(this.otpPeer));
    }

    protected void prepareConnection(Connection con) throws IOException {
    }

    protected Connection getSharedConnectionProxy(Connection target) {
        ArrayList<Class<Connection>> classes = new ArrayList<Class<Connection>>(1);
        classes.add(Connection.class);
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new SharedConnectionInvocationHandler(target));
    }

    public void afterPropertiesSet() {
        Assert.isTrue((this.selfNodeName != null || this.peerNodeName != null ? 1 : 0) != 0, (String)"'selfNodeName' or 'peerNodeName' is required");
        String selfNodeNameToUse = this.selfNodeName;
        if (this.isUniqueSelfNodeName()) {
            selfNodeNameToUse = this.selfNodeName + "-" + UUID.randomUUID().toString();
            this.logger.debug((Object)("Creating OtpSelf with node name = [" + selfNodeNameToUse + "]"));
        }
        try {
            this.otpSelf = this.cookie == null ? new OtpSelf(selfNodeNameToUse.trim()) : new OtpSelf(selfNodeNameToUse.trim(), this.cookie);
        }
        catch (IOException e) {
            throw new OtpIOException(e);
        }
        this.otpPeer = new OtpPeer(this.peerNodeName.trim());
    }

    private class SharedConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public SharedConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return "Shared Otp Connection: " + this.target;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

