/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.exec;

public class ExecuteWatchdog
implements Runnable {
    private Process process;
    private int timeout;
    private boolean watch = false;
    private Exception caught = null;
    private boolean killedProcess = false;
    Thread execThread;
    private boolean dontkill = false;

    public ExecuteWatchdog(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = timeout;
    }

    public void setDontkill(boolean b) {
        this.dontkill = b;
    }

    public synchronized void start(Process process, Thread execThread) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        this.execThread = execThread;
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.watch = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            long now;
            long until = System.currentTimeMillis() + (long)this.timeout;
            while (this.watch && until > (now = System.currentTimeMillis())) {
                try {
                    this.wait(until - now);
                }
                catch (InterruptedException e) {}
            }
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (this.watch) {
                    this.killedProcess = true;
                    if (!this.dontkill) {
                        this.process.destroy();
                    }
                    if (this.execThread != null) {
                        this.execThread.interrupt();
                    }
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
        }
        finally {
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public Exception getException() {
        return this.caught;
    }

    public boolean isWatching() {
        return this.watch;
    }

    public boolean killedProcess() {
        return this.killedProcess;
    }
}

