/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.Repeat;

@Deprecated
public class RepeatProcessor
implements MethodRule {
    private static final Log LOGGER = LogFactory.getLog(RepeatProcessor.class);
    private final int concurrency;
    private volatile boolean initialized = false;
    private volatile boolean finalizing = false;

    public RepeatProcessor() {
        this(0);
    }

    public RepeatProcessor(int concurrency) {
        this.concurrency = concurrency < 0 ? 0 : concurrency;
    }

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        Repeat repeat = (Repeat)AnnotationUtils.findAnnotation((Method)method.getMethod(), Repeat.class);
        if (repeat == null) {
            return base;
        }
        final int repeats = repeat.value();
        if (repeats <= 1) {
            return base;
        }
        this.initializeIfNecessary(target);
        if (this.concurrency <= 0) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        for (int i = 0; i < repeats; ++i) {
                            try {
                                base.evaluate();
                                continue;
                            }
                            catch (Throwable t) {
                                throw new IllegalStateException("Failed on iteration: " + i + " of " + repeats + " (started at 0)", t);
                            }
                        }
                    }
                    finally {
                        RepeatProcessor.this.finalizeIfNecessary(target);
                    }
                }
            };
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
                ExecutorService executor = Executors.newFixedThreadPool(RepeatProcessor.this.concurrency);
                ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(executor);
                try {
                    int i = 0;
                    while (i < repeats) {
                        final int count = i++;
                        results.add(completionService.submit(new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                try {
                                    base.evaluate();
                                }
                                catch (Throwable t) {
                                    throw new IllegalStateException("Failed on iteration: " + count, t);
                                }
                                return true;
                            }
                        }));
                    }
                    for (i = 0; i < repeats; ++i) {
                        Future future = completionService.take();
                        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)future.get())).as("Null result from completer", new Object[0])).isTrue();
                    }
                }
                finally {
                    executor.shutdownNow();
                    RepeatProcessor.this.finalizeIfNecessary(target);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeIfNecessary(Object target) {
        this.finalizing = true;
        List afters = new TestClass(target.getClass()).getAnnotatedMethods(After.class);
        try {
            if (!afters.isEmpty()) {
                LOGGER.debug((Object)"Running @After methods");
                try {
                    new RunAfters(new Statement(){

                        public void evaluate() {
                        }
                    }, afters, target).evaluate();
                }
                catch (Throwable e) {
                    Assertions.fail((String)("Unexpected throwable " + e));
                }
            }
        }
        finally {
            this.finalizing = false;
        }
    }

    private void initializeIfNecessary(Object target) {
        TestClass testClass = new TestClass(target.getClass());
        List befores = testClass.getAnnotatedMethods(Before.class);
        if (!befores.isEmpty()) {
            LOGGER.debug((Object)"Running @Before methods");
            try {
                new RunBefores(new Statement(){

                    public void evaluate() {
                    }
                }, befores, target).evaluate();
            }
            catch (Throwable e) {
                Assertions.fail((String)("Unexpected throwable " + e));
            }
            this.initialized = true;
        }
        if (!testClass.getAnnotatedMethods(After.class).isEmpty()) {
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public int getConcurrency() {
        return this.concurrency > 0 ? this.concurrency : 1;
    }
}

