/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.amqp.rabbit.junit.JUnitUtils;

public class LongRunningIntegrationTest
extends TestWatcher {
    private static final Log logger = LogFactory.getLog(LongRunningIntegrationTest.class);
    public static final String RUN_LONG_INTEGRATION_TESTS = "RUN_LONG_INTEGRATION_TESTS";
    private boolean shouldRun = false;

    public LongRunningIntegrationTest() {
        this(RUN_LONG_INTEGRATION_TESTS);
    }

    public LongRunningIntegrationTest(String property) {
        this.shouldRun = JUnitUtils.parseBooleanProperty(property);
    }

    public Statement apply(Statement base, Description description) {
        if (!this.shouldRun) {
            logger.info((Object)("Skipping long running test " + description.toString()));
        }
        Assume.assumeTrue((boolean)this.shouldRun);
        return super.apply(base, description);
    }

    public boolean isShouldRun() {
        return this.shouldRun;
    }
}

