/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.amqp.rabbit.junit.BrokerTestUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public final class BrokerRunningSupport {
    private static final int SIXTEEN = 16;
    public static final String BROKER_ADMIN_URI = "RABBITMQ_TEST_ADMIN_URI";
    public static final String BROKER_HOSTNAME = "RABBITMQ_TEST_HOSTNAME";
    public static final String BROKER_PORT = "RABBITMQ_TEST_PORT";
    public static final String BROKER_USER = "RABBITMQ_TEST_USER";
    public static final String BROKER_PW = "RABBITMQ_TEST_PASSWORD";
    public static final String BROKER_ADMIN_USER = "RABBITMQ_TEST_ADMIN_USER";
    public static final String BROKER_ADMIN_PW = "RABBITMQ_TEST_ADMIN_PASSWORD";
    public static final String BROKER_REQUIRED = "RABBITMQ_SERVER_REQUIRED";
    public static final String DEFAULT_QUEUE_NAME = BrokerRunningSupport.class.getName();
    private static final String GUEST = "guest";
    private static final Log LOGGER = LogFactory.getLog(BrokerRunningSupport.class);
    private static final Map<Integer, Boolean> BROKER_ONLINE = new HashMap<Integer, Boolean>();
    private static final Map<String, String> ENVIRONMENT_OVERRIDES = new HashMap<String, String>();
    private final boolean purge;
    private final boolean management;
    private final String[] queues;
    private int port;
    private String hostName = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_HOSTNAME", "localhost");
    private String adminUri = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_ADMIN_URI", null);
    private ConnectionFactory connectionFactory;
    private String user = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_USER", "guest");
    private String password = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_PASSWORD", "guest");
    private String adminUser = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_ADMIN_USER", "guest");
    private String adminPassword = BrokerRunningSupport.fromEnvironment("RABBITMQ_TEST_ADMIN_PASSWORD", "guest");
    private boolean purgeAfterEach;

    private static String fromEnvironment(String key, String defaultValue) {
        String environmentValue = ENVIRONMENT_OVERRIDES.get(key);
        if (!StringUtils.hasText((String)environmentValue)) {
            environmentValue = System.getenv(key);
        }
        if (StringUtils.hasText((String)environmentValue)) {
            return environmentValue;
        }
        return defaultValue;
    }

    public static void setEnvironmentVariableOverrides(Map<String, String> environmentVariables) {
        ENVIRONMENT_OVERRIDES.putAll(environmentVariables);
    }

    public static void clearEnvironmentVariableOverrides() {
        ENVIRONMENT_OVERRIDES.clear();
    }

    public static BrokerRunningSupport isRunningWithEmptyQueues(String ... names) {
        return new BrokerRunningSupport(true, names);
    }

    public static BrokerRunningSupport isRunning() {
        return new BrokerRunningSupport(true);
    }

    public static BrokerRunningSupport isNotRunning() {
        return new BrokerRunningSupport(false);
    }

    public static BrokerRunningSupport isBrokerAndManagementRunning() {
        return new BrokerRunningSupport(false, true, new String[0]);
    }

    public static BrokerRunningSupport isBrokerAndManagementRunningWithEmptyQueues(String ... queues) {
        return new BrokerRunningSupport(true, true, queues);
    }

    private BrokerRunningSupport(boolean purge, String ... queues) {
        this(purge, false, queues);
    }

    BrokerRunningSupport(boolean purge, boolean management, String ... queues) {
        this.queues = queues != null ? Arrays.copyOf(queues, queues.length) : null;
        this.purge = purge;
        this.management = management;
        this.setPort(BrokerRunningSupport.fromEnvironment(BROKER_PORT, null) == null ? BrokerTestUtils.getPort() : Integer.valueOf(BrokerRunningSupport.fromEnvironment(BROKER_PORT, null)));
    }

    private BrokerRunningSupport(boolean assumeOnline) {
        this(assumeOnline, DEFAULT_QUEUE_NAME);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAdminUri(String adminUri) {
        this.adminUri = adminUri;
    }

    public void setAdminUser(String user) {
        this.adminUser = user;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public boolean isPurgeAfterEach() {
        return this.purgeAfterEach;
    }

    public void setPurgeAfterEach(boolean purgeAfterEach) {
        this.purgeAfterEach = purgeAfterEach;
    }

    public void test() throws BrokerNotAliveException {
        if (Boolean.FALSE.equals(BROKER_ONLINE.get(this.port))) {
            throw new BrokerNotAliveException("Require broker online and it's not");
        }
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            channel = this.createQueues(connection);
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            try {
                BROKER_ONLINE.put(this.port, false);
                throw new BrokerNotAliveException("RabbitMQ Broker is required, but not available", e);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, channel);
                throw throwable;
            }
        }
    }

    private Connection getConnection(ConnectionFactory cf) throws IOException, TimeoutException {
        Connection connection = cf.newConnection();
        connection.setId(this.generateId());
        return connection;
    }

    private Channel createQueues(Connection connection) throws IOException, URISyntaxException {
        Channel channel = connection.createChannel();
        for (String queueName : this.queues) {
            if (this.purge) {
                LOGGER.debug((Object)("Deleting queue: " + queueName));
                channel.queueDelete(queueName);
            }
            if (this.isDefaultQueue(queueName)) {
                channel.queueDelete(queueName);
                continue;
            }
            channel.queueDeclare(queueName, true, false, false, null);
        }
        if (this.management && !this.alivenessTest()) {
            throw new BrokerNotAliveException("Aliveness test failed for localhost:15672 guest/quest; management not available");
        }
        return channel;
    }

    private boolean alivenessTest() throws URISyntaxException {
        URI uri = new URI(this.getAdminUri()).resolve("/api/aliveness-test/" + UriUtils.encodePathSegment((String)"/", (Charset)StandardCharsets.UTF_8));
        final HttpHost host = new HttpHost(uri.getHost(), uri.getPort());
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(){

            @Nullable
            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                BasicAuthCache cache = new BasicAuthCache();
                BasicScheme scheme = new BasicScheme();
                cache.put(host, (AuthScheme)scheme);
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.auth.auth-cache", (Object)cache);
                return context;
            }
        });
        template.getInterceptors().add(new BasicAuthenticationInterceptor(this.adminUser, this.adminPassword));
        ResponseEntity response = template.exchange(uri, HttpMethod.GET, null, String.class);
        String body = null;
        if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
            body = (String)response.getBody();
        }
        return body != null ? body.equals("{\"status\":\"ok\"}") : false;
    }

    public static boolean fatal() {
        String serversRequired = System.getenv(BROKER_REQUIRED);
        if (Boolean.parseBoolean(serversRequired)) {
            LOGGER.error((Object)"RABBITMQ IS REQUIRED BUT NOT AVAILABLE");
            return true;
        }
        return false;
    }

    public String generateId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return "SpringBrokerRunning." + Base64Utils.encodeToUrlSafeString((byte[])bb.array()).replaceAll("=", "");
    }

    private boolean isDefaultQueue(String queue) {
        return DEFAULT_QUEUE_NAME.equals(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestQueues(String ... additionalQueues) {
        List<String> queuesToRemove = Arrays.asList(this.queues);
        if (additionalQueues != null) {
            queuesToRemove = new ArrayList<String>(queuesToRemove);
            queuesToRemove.addAll(Arrays.asList(additionalQueues));
        }
        LOGGER.debug((Object)("deleting test queues: " + queuesToRemove));
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".queueDelete");
            channel = connection.createChannel();
            for (String queue : queuesToRemove) {
                channel.queueDelete(queue);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExchanges(String ... exchanges) {
        LOGGER.debug((Object)("deleting test exchanges: " + Arrays.toString(exchanges)));
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".exchangeDelete");
            channel = connection.createChannel();
            for (String exchange : exchanges) {
                channel.exchangeDelete(exchange);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to delete exchanges", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeTestQueues() {
        this.removeTestQueues(new String[0]);
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            channel = this.createQueues(connection);
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            try {
                LOGGER.warn((Object)("Failed to re-declare queues during purge: " + e.getMessage()));
                this.closeResources(connection, channel);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, channel);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQueues(String ... queuesToDelete) {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".queueDelete");
            channel = connection.createChannel();
            for (String queue : queuesToDelete) {
                channel.queueDelete(queue);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExchanges(String ... exchanges) {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".exchangeDelete");
            channel = connection.createChannel();
            for (String exchange : exchanges) {
                channel.exchangeDelete(exchange);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ConnectionFactory();
            if (StringUtils.hasText((String)this.hostName)) {
                this.connectionFactory.setHost(this.hostName);
            } else {
                this.connectionFactory.setHost("localhost");
            }
            this.connectionFactory.setPort(this.port);
            this.connectionFactory.setUsername(this.user);
            this.connectionFactory.setPassword(this.password);
            this.connectionFactory.setAutomaticRecoveryEnabled(false);
        }
        return this.connectionFactory;
    }

    public String getAdminUri() {
        if (!StringUtils.hasText((String)this.adminUri)) {
            this.adminUri = !StringUtils.hasText((String)this.hostName) ? "http://localhost:15672/api/" : "http://" + this.hostName + ":15672/api/";
        }
        return this.adminUri;
    }

    private void closeResources(Connection connection, Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException | TimeoutException exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class BrokerNotAliveException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        BrokerNotAliveException(String message) {
            super(message);
        }

        BrokerNotAliveException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

