/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.test.RabbitListenerTest;
import org.springframework.amqp.rabbit.test.mockito.LambdaAnswer;
import org.springframework.amqp.rabbit.test.mockito.LatchCountDownAndCallRealMethodAnswer;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitListenerTestHarness
extends RabbitListenerAnnotationBeanPostProcessor {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<String, CaptureAdvice> listenerCapture = new HashMap<String, CaptureAdvice>();
    private final Map<String, Object> listeners = new HashMap<String, Object>();
    private final Map<String, Object> delegates = new HashMap<String, Object>();
    private final AnnotationAttributes attributes;

    public RabbitListenerTestHarness(AnnotationMetadata importMetadata) {
        Map map = importMetadata.getAnnotationAttributes(RabbitListenerTest.class.getName());
        this.attributes = AnnotationAttributes.fromMap((Map)map);
        Assert.notNull((Object)this.attributes, () -> "@RabbitListenerTest is not present on importing class " + importMetadata.getClassName());
    }

    protected Collection<Declarable> processListener(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object bean, Object target, String beanName) {
        Object proxy = bean;
        String id = rabbitListener.id();
        if (StringUtils.hasText((String)id)) {
            if (this.attributes.getBoolean("spy")) {
                this.delegates.put(id, proxy);
                proxy = Mockito.mock(AopTestUtils.getUltimateTargetObject((Object)proxy).getClass(), (Answer)AdditionalAnswers.delegatesTo((Object)proxy));
                this.listeners.put(id, proxy);
            }
            if (this.attributes.getBoolean("capture")) {
                try {
                    ProxyFactoryBean pfb = new ProxyFactoryBean();
                    pfb.setProxyTargetClass(true);
                    pfb.setTarget(proxy);
                    CaptureAdvice advice = new CaptureAdvice();
                    pfb.addAdvice((Advice)advice);
                    proxy = pfb.getObject();
                    this.listenerCapture.put(id, advice);
                }
                catch (Exception e) {
                    throw new AmqpException("Failed to proxy @RabbitListener with id: " + id, (Throwable)e);
                }
            }
        } else {
            this.logger.info((Object)"The test harness can only proxy @RabbitListeners with an 'id' attribute");
        }
        return super.processListener(endpoint, rabbitListener, proxy, target, beanName);
    }

    public LatchCountDownAndCallRealMethodAnswer getLatchAnswerFor(String id, int count) {
        return new LatchCountDownAndCallRealMethodAnswer(count, this.delegates.get(id));
    }

    public <T> LambdaAnswer<T> getLambdaAnswerFor(String id, boolean callRealMethod, LambdaAnswer.ValueToReturn<T> callback) {
        return new LambdaAnswer<T>(callRealMethod, callback, this.delegates.get(id));
    }

    public InvocationData getNextInvocationDataFor(String id, long wait, TimeUnit unit) throws InterruptedException {
        CaptureAdvice advice = this.listenerCapture.get(id);
        if (advice != null) {
            return (InvocationData)advice.invocationData.poll(wait, unit);
        }
        return null;
    }

    public <T> T getSpy(String id) {
        return (T)this.listeners.get(id);
    }

    public <T> T getDelegate(String id) {
        return (T)this.delegates.get(id);
    }

    public static class InvocationData {
        private final MethodInvocation invocation;
        private final Object result;
        private final Throwable throwable;

        public InvocationData(MethodInvocation invocation, Object result) {
            this.invocation = invocation;
            this.result = result;
            this.throwable = null;
        }

        public InvocationData(MethodInvocation invocation, Throwable throwable) {
            this.invocation = invocation;
            this.result = null;
            this.throwable = throwable;
        }

        public Object[] getArguments() {
            return this.invocation.getArguments();
        }

        public Object getResult() {
            return this.result;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private static final class CaptureAdvice
    implements MethodInterceptor {
        private final BlockingQueue<InvocationData> invocationData = new LinkedBlockingQueue<InvocationData>();

        CaptureAdvice() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            boolean isListenerMethod = AnnotationUtils.findAnnotation((Method)invocation.getMethod(), RabbitListener.class) != null || AnnotationUtils.findAnnotation((Method)invocation.getMethod(), RabbitHandler.class) != null;
            try {
                Object result = invocation.proceed();
                if (isListenerMethod) {
                    this.invocationData.put(new InvocationData(invocation, result));
                }
                return result;
            }
            catch (Throwable t) {
                if (isListenerMethod) {
                    this.invocationData.put(new InvocationData(invocation, t));
                }
                throw t;
            }
        }
    }
}

