/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RabbitNamespaceUtils {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    private static final String ACKNOWLEDGE_AUTO = "auto";
    private static final String ACKNOWLEDGE_MANUAL = "manual";
    private static final String ACKNOWLEDGE_NONE = "none";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String CONCURRENCY_ATTRIBUTE = "concurrency";
    private static final String PREFETCH_ATTRIBUTE = "prefetch";
    private static final String TRANSACTION_SIZE_ATTRIBUTE = "transaction-size";
    private static final String PHASE_ATTRIBUTE = "phase";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String ADVICE_CHAIN_ATTRIBUTE = "advice-chain";
    private static final String REQUEUE_REJECTED_ATTRIBUTE = "requeue-rejected";

    public static BeanDefinition parseContainer(Element containerEle, ParserContext parserContext) {
        String adviceChain;
        String autoStartup;
        String phase;
        String requeueRejected;
        String transactionSize;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        AcknowledgeMode acknowledgeMode;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition(SimpleMessageListenerContainer.class);
        containerDef.setSource(parserContext.extractSource((Object)containerEle));
        String connectionFactoryBeanName = "rabbitConnectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", (Object)containerEle);
        }
        if (StringUtils.hasText((String)connectionFactoryBeanName)) {
            containerDef.getPropertyValues().add("connectionFactory", (Object)new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (StringUtils.hasText((String)(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("taskExecutor", (Object)new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText((String)(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("errorHandler", (Object)new RuntimeBeanReference(errorHandlerBeanName));
        }
        if ((acknowledgeMode = RabbitNamespaceUtils.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            containerDef.getPropertyValues().add("acknowledgeMode", (Object)acknowledgeMode);
        }
        if (StringUtils.hasText((String)(transactionManagerBeanName = containerEle.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("transactionManager", (Object)new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText((String)(concurrency = containerEle.getAttribute(CONCURRENCY_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("concurrentConsumers", (Object)new TypedStringValue(concurrency));
        }
        if (StringUtils.hasText((String)(prefetch = containerEle.getAttribute(PREFETCH_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("prefetchCount", (Object)new TypedStringValue(prefetch));
        }
        if (StringUtils.hasText((String)(transactionSize = containerEle.getAttribute(TRANSACTION_SIZE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("txSize", (Object)new TypedStringValue(transactionSize));
        }
        if (StringUtils.hasText((String)(requeueRejected = containerEle.getAttribute(REQUEUE_REJECTED_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("defaultRequeueRejected", (Object)new TypedStringValue(requeueRejected));
        }
        if (StringUtils.hasText((String)(phase = containerEle.getAttribute(PHASE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add(PHASE_ATTRIBUTE, (Object)phase);
        }
        if (StringUtils.hasText((String)(autoStartup = containerEle.getAttribute(AUTO_STARTUP_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("autoStartup", (Object)new TypedStringValue(autoStartup));
        }
        if (StringUtils.hasText((String)(adviceChain = containerEle.getAttribute(ADVICE_CHAIN_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("adviceChain", (Object)new RuntimeBeanReference(adviceChain));
        }
        return containerDef;
    }

    private static AcknowledgeMode parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        AcknowledgeMode acknowledgeMode = null;
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            if (ACKNOWLEDGE_AUTO.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.AUTO;
            } else if (ACKNOWLEDGE_MANUAL.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.MANUAL;
            } else if (ACKNOWLEDGE_NONE.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.NONE;
            } else {
                parserContext.getReaderContext().error("Invalid listener container 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"manual\", and \"none\" supported.", (Object)ele);
            }
            return acknowledgeMode;
        }
        return null;
    }
}

