/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitResourceHolder
extends ResourceHolderSupport {
    private static final Log logger = LogFactory.getLog(RabbitResourceHolder.class);
    private boolean frozen = false;
    private final List<Connection> connections = new LinkedList<Connection>();
    private final List<Channel> channels = new LinkedList<Channel>();
    private final Map<Connection, List<Channel>> channelsPerConnection = new HashMap<Connection, List<Channel>>();
    private MultiValueMap<Channel, Long> deliveryTags = new LinkedMultiValueMap();
    private boolean transactional;

    public RabbitResourceHolder() {
    }

    public RabbitResourceHolder(Channel channel) {
        this();
        this.addChannel(channel);
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void addConnection(Connection connection) {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot add Connection because RabbitResourceHolder is frozen");
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public final void addChannel(Channel channel) {
        this.addChannel(channel, null);
    }

    public final void addChannel(Channel channel, Connection connection) {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot add Channel because RabbitResourceHolder is frozen");
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        if (!this.channels.contains(channel)) {
            this.channels.add(channel);
            if (connection != null) {
                List<Channel> channels = this.channelsPerConnection.get(connection);
                if (channels == null) {
                    channels = new LinkedList<Channel>();
                    this.channelsPerConnection.put(connection, channels);
                }
                channels.add(channel);
            }
        }
    }

    public boolean containsChannel(Channel channel) {
        return this.channels.contains(channel);
    }

    public Connection getConnection() {
        return !this.connections.isEmpty() ? this.connections.get(0) : null;
    }

    public Connection getConnection(Class<? extends Connection> connectionType) {
        return (Connection)CollectionUtils.findValueOfType(this.connections, connectionType);
    }

    public Channel getChannel() {
        return !this.channels.isEmpty() ? this.channels.get(0) : null;
    }

    public void commitAll() throws AmqpException {
        try {
            for (Channel channel : this.channels) {
                if (this.deliveryTags.containsKey((Object)channel)) {
                    for (Long deliveryTag : (List)this.deliveryTags.get((Object)channel)) {
                        channel.basicAck(deliveryTag.longValue(), false);
                    }
                }
                channel.txCommit();
            }
        }
        catch (IOException e) {
            throw new AmqpException("failed to commit RabbitMQ transaction", (Throwable)e);
        }
    }

    public void closeAll() {
        for (Channel channel : this.channels) {
            try {
                channel.close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close synchronized Rabbit Channel after transaction", ex);
            }
        }
        for (Connection con : this.connections) {
            RabbitUtils.closeConnection(con);
        }
        this.connections.clear();
        this.channels.clear();
        this.channelsPerConnection.clear();
    }

    public void addDeliveryTag(Channel channel, long deliveryTag) {
        this.deliveryTags.add((Object)channel, (Object)deliveryTag);
    }

    public void rollbackAll() {
        for (Channel channel : this.channels) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rolling back messages to channel: " + channel));
            }
            RabbitUtils.rollbackIfNecessary(channel);
            if (!this.deliveryTags.containsKey((Object)channel)) continue;
            for (Long deliveryTag : (List)this.deliveryTags.get((Object)channel)) {
                try {
                    channel.basicReject(deliveryTag.longValue(), true);
                }
                catch (IOException ex) {
                    throw new AmqpIOException(ex);
                }
            }
            RabbitUtils.commitIfNecessary(channel);
        }
    }

    public boolean isChannelTransactional() {
        return this.transactional;
    }
}

