/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MessageListenerAdapter
implements MessageListener,
ChannelAwareMessageListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    private static final String DEFAULT_RESPONSE_ROUTING_KEY = "";
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";
    private String responseRoutingKey = "";
    private String responseExchange = null;
    private volatile boolean mandatoryPublish;
    private volatile boolean immediatePublish;
    private MessageConverter messageConverter;
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private String encoding = "UTF-8";

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    public MessageListenerAdapter(Object delegate, MessageConverter messageConverter) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
        this.setMessageConverter(messageConverter);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setResponseRoutingKey(String responseRoutingKey) {
        this.responseRoutingKey = responseRoutingKey;
    }

    public void setResponseExchange(String responseExchange) {
        this.responseExchange = responseExchange;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMandatoryPublish(boolean mandatoryPublish) {
        this.mandatoryPublish = mandatoryPublish;
    }

    public void setImmediatePublish(boolean immediatePublish) {
        this.immediatePublish = immediatePublish;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, null);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        Object convertedMessage;
        String methodName;
        Object delegate = this.getDelegate();
        if (delegate != this) {
            if (delegate instanceof ChannelAwareMessageListener) {
                if (channel != null) {
                    ((ChannelAwareMessageListener)delegate).onMessage(message, channel);
                    return;
                }
                if (!(delegate instanceof MessageListener)) {
                    throw new AmqpIllegalStateException("MessageListenerAdapter cannot handle a ChannelAwareMessageListener delegate if it hasn't been invoked with a Channel itself");
                }
            }
            if (delegate instanceof MessageListener) {
                ((MessageListener)delegate).onMessage(message);
                return;
            }
        }
        if ((methodName = this.getListenerMethodName(message, convertedMessage = this.extractMessage(message))) == null) {
            throw new AmqpIllegalStateException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
        }
        Object[] listenerArguments = this.buildListenerArguments(convertedMessage);
        Object result = this.invokeListenerMethod(methodName, listenerArguments);
        if (result != null) {
            this.handleResult(result, message, channel);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter((MessageConverter)new SimpleMessageConverter());
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        return message;
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) throws Exception {
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments) throws Exception {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                throw new AmqpIOException((IOException)targetEx);
            }
            throw new ListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            ArrayList<String> arrayClass = new ArrayList<String>();
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    arrayClass.add(arguments[i].getClass().toString());
                }
            }
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with argument type = [" + StringUtils.collectionToCommaDelimitedString(arrayClass) + "], value = [" + ObjectUtils.nullSafeToString((Object[])arguments) + "]", ex);
        }
    }

    protected void handleResult(Object result, Message request, Channel channel) throws Exception {
        if (channel != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listener method returned result [" + result + "] - generating response message for it"));
            }
            Message response = this.buildMessage(channel, result);
            this.postProcessResponse(request, response);
            Address replyTo = this.getReplyToAddress(request);
            this.sendResponse(channel, replyTo, response);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener method returned result [" + result + "]: not generating response message for it because of no Rabbit Channel given"));
        }
    }

    protected String getReceivedExchange(Message request) {
        return request.getMessageProperties().getReceivedExchange();
    }

    protected Message buildMessage(Channel session, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (Message)result;
    }

    protected void postProcessResponse(Message request, Message response) throws Exception {
        String messageId;
        byte[] correlation = request.getMessageProperties().getCorrelationId();
        if (correlation == null && (messageId = request.getMessageProperties().getMessageId()) != null) {
            correlation = messageId.getBytes(DEFAULT_ENCODING);
        }
        response.getMessageProperties().setCorrelationId(correlation);
    }

    protected Address getReplyToAddress(Message request) throws Exception {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.responseExchange == null) {
                throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default response Exchange was set.");
            }
            replyTo = new Address(null, this.responseExchange, this.responseRoutingKey);
        }
        return replyTo;
    }

    protected void sendResponse(Channel channel, Address replyTo, Message message) throws Exception {
        this.postProcessChannel(channel, message);
        try {
            this.logger.debug((Object)("Publishing response to exchanage = [" + replyTo.getExchangeName() + "], routingKey = [" + replyTo.getRoutingKey() + "]"));
            channel.basicPublish(replyTo.getExchangeName(), replyTo.getRoutingKey(), this.mandatoryPublish, this.immediatePublish, this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding), message.getBody());
        }
        catch (Exception ex) {
            throw RabbitUtils.convertRabbitAccessException(ex);
        }
    }

    protected void postProcessChannel(Channel channel, Message response) throws Exception {
    }
}

