/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.Assert;

public class RabbitAdmin
implements AmqpAdmin,
ApplicationContextAware,
InitializingBean {
    protected static final String DEFAULT_EXCHANGE_NAME = "";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RabbitTemplate rabbitTemplate;
    private volatile boolean running = false;
    private volatile boolean autoStartup = true;
    private volatile ApplicationContext applicationContext;
    private final Object lifecycleMonitor = new Object();
    private final ConnectionFactory connectionFactory;

    public RabbitAdmin(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.rabbitTemplate = new RabbitTemplate(connectionFactory);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void declareExchange(final Exchange exchange) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareExchanges(channel, new Exchange[]{exchange});
                return null;
            }
        });
    }

    @ManagedOperation
    public boolean deleteExchange(final String exchangeName) {
        return this.rabbitTemplate.execute(new ChannelCallback<Boolean>(){

            @Override
            public Boolean doInRabbit(Channel channel) throws Exception {
                if (RabbitAdmin.this.isDeletingDefaultExchange(exchangeName)) {
                    return true;
                }
                try {
                    channel.exchangeDelete(exchangeName);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    @ManagedOperation
    public void declareQueue(final Queue queue) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareQueues(channel, new Queue[]{queue});
                return null;
            }
        });
    }

    @ManagedOperation
    public Queue declareQueue() {
        AMQP.Queue.DeclareOk declareOk = this.rabbitTemplate.execute(new ChannelCallback<AMQP.Queue.DeclareOk>(){

            @Override
            public AMQP.Queue.DeclareOk doInRabbit(Channel channel) throws Exception {
                return channel.queueDeclare();
            }
        });
        Queue queue = new Queue(declareOk.getQueue(), false, true, true);
        return queue;
    }

    @ManagedOperation
    public boolean deleteQueue(final String queueName) {
        return this.rabbitTemplate.execute(new ChannelCallback<Boolean>(){

            @Override
            public Boolean doInRabbit(Channel channel) throws Exception {
                try {
                    channel.queueDelete(queueName);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    @ManagedOperation
    public void deleteQueue(final String queueName, final boolean unused, final boolean empty) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                channel.queueDelete(queueName, unused, empty);
                return null;
            }
        });
    }

    @ManagedOperation
    public void purgeQueue(final String queueName, boolean noWait) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                channel.queuePurge(queueName);
                return null;
            }
        });
    }

    @ManagedOperation
    public void declareBinding(final Binding binding) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareBindings(channel, new Binding[]{binding});
                return null;
            }
        });
    }

    @ManagedOperation
    public void removeBinding(final Binding binding) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                if (binding.isDestinationQueue()) {
                    if (RabbitAdmin.this.isRemovingImplicitQueueBinding(binding)) {
                        return null;
                    }
                    channel.queueUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                } else {
                    channel.exchangeUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                }
                return null;
            }
        });
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running || !this.autoStartup) {
                return;
            }
            this.connectionFactory.addConnectionListener(new ConnectionListener(){
                private AtomicBoolean initializing = new AtomicBoolean(false);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCreate(Connection connection) {
                    if (!this.initializing.compareAndSet(false, true)) {
                        return;
                    }
                    try {
                        RabbitAdmin.this.initialize();
                    }
                    finally {
                        this.initializing.compareAndSet(true, false);
                    }
                }

                public void onClose(Connection connection) {
                }
            });
            this.running = true;
        }
    }

    public void initialize() {
        if (this.applicationContext == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"no ApplicationContext has been set, cannot auto-declare Exchanges, Queues, and Bindings");
            }
            return;
        }
        this.logger.debug((Object)"Initializing declarations");
        final Collection exchanges = this.applicationContext.getBeansOfType(Exchange.class).values();
        final Collection queues = this.applicationContext.getBeansOfType(Queue.class).values();
        final Collection bindings = this.applicationContext.getBeansOfType(Binding.class).values();
        for (Exchange exchange : exchanges) {
            if (!exchange.isDurable()) {
                this.logger.warn((Object)("Auto-declaring a non-durable Exchange (" + exchange.getName() + "). It will be deleted by the broker if it shuts down, and can be redeclared by closing and reopening the connection."));
            }
            if (!exchange.isAutoDelete()) continue;
            this.logger.warn((Object)("Auto-declaring an auto-delete Exchange (" + exchange.getName() + "). It will be deleted by the broker if not in use (if all bindings are deleted), but will only be redeclared if the connection is closed and reopened."));
        }
        for (Queue queue : queues) {
            if (!queue.isDurable()) {
                this.logger.warn((Object)("Auto-declaring a non-durable Queue (" + queue.getName() + "). It will be redeclared if the broker stops and is restarted while the connection factory is alive, but all messages will be lost."));
            }
            if (queue.isAutoDelete()) {
                this.logger.warn((Object)("Auto-declaring an auto-delete Queue (" + queue.getName() + "). It will be deleted by the broker if not in use, and all messages will be lost.  Redeclared when the connection is closed and reopened."));
            }
            if (!queue.isExclusive()) continue;
            this.logger.warn((Object)("Auto-declaring an exclusive Queue (" + queue.getName() + "). It cannot be accessed by consumers on another connection, and will be redeclared if the connection is reopened."));
        }
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareExchanges(channel, exchanges.toArray(new Exchange[exchanges.size()]));
                RabbitAdmin.this.declareQueues(channel, queues.toArray(new Queue[queues.size()]));
                RabbitAdmin.this.declareBindings(channel, bindings.toArray(new Binding[bindings.size()]));
                return null;
            }
        });
        this.logger.debug((Object)"Declarations finished");
    }

    private void declareExchanges(Channel channel, Exchange ... exchanges) throws IOException {
        for (Exchange exchange : exchanges) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("declaring Exchange '" + exchange.getName() + "'"));
            }
            if (this.isDeclaringDefaultExchange(exchange)) continue;
            channel.exchangeDeclare(exchange.getName(), exchange.getType(), exchange.isDurable(), exchange.isAutoDelete(), exchange.getArguments());
        }
    }

    private void declareQueues(Channel channel, Queue ... queues) throws IOException {
        for (Queue queue : queues) {
            if (!queue.getName().startsWith("amq.")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("declaring Queue '" + queue.getName() + "'"));
                }
                channel.queueDeclare(queue.getName(), queue.isDurable(), queue.isExclusive(), queue.isAutoDelete(), queue.getArguments());
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)"Queue with name that starts with 'amq.' cannot be declared.");
        }
    }

    private void declareBindings(Channel channel, Binding ... bindings) throws IOException {
        for (Binding binding : bindings) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Binding destination [" + binding.getDestination() + " (" + binding.getDestinationType() + ")] to exchange [" + binding.getExchange() + "] with routing key [" + binding.getRoutingKey() + "]"));
            }
            if (binding.isDestinationQueue()) {
                if (this.isDeclaringImplicitQueueBinding(binding)) continue;
                channel.queueBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                continue;
            }
            channel.exchangeBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
        }
    }

    private boolean isDeclaringDefaultExchange(Exchange exchange) {
        if (this.isDefaultExchange(exchange.getName())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Default exchange is pre-declared by server.");
            }
            return true;
        }
        return false;
    }

    private boolean isDeletingDefaultExchange(String exchangeName) {
        if (this.isDefaultExchange(exchangeName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Default exchange cannot be deleted.");
            }
            return true;
        }
        return false;
    }

    private boolean isDefaultExchange(String exchangeName) {
        return DEFAULT_EXCHANGE_NAME.equals(exchangeName);
    }

    private boolean isDeclaringImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The default exchange is implicitly bound to every queue, with a routing key equal to the queue name.");
            }
            return true;
        }
        return false;
    }

    private boolean isRemovingImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Cannot remove implicit default exchange binding to queue.");
            }
            return true;
        }
        return false;
    }

    private boolean isImplicitQueueBinding(Binding binding) {
        return this.isDefaultExchange(binding.getExchange()) && binding.getDestination().equals(binding.getRoutingKey());
    }
}

