/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core.support;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.support.BatchingStrategy;
import org.springframework.amqp.rabbit.core.support.MessageBatch;
import org.springframework.util.Assert;

public class SimpleBatchingStrategy
implements BatchingStrategy {
    private final int batchSize;
    private final int bufferLimit;
    private final long timeout;
    private final List<Message> messages = new ArrayList<Message>();
    private volatile String exchange;
    private volatile String routingKey;
    private volatile int currentSize;

    public SimpleBatchingStrategy(int batchSize, int bufferLimit, long timeout) {
        this.batchSize = batchSize;
        this.bufferLimit = bufferLimit;
        this.timeout = timeout;
    }

    @Override
    public MessageBatch addToBatch(String exchange, String routingKey, Message message) {
        if (this.exchange != null) {
            Assert.isTrue((boolean)this.exchange.equals(exchange), (String)"Cannot send to different exchanges in the same batch");
        } else {
            this.exchange = exchange;
        }
        if (this.routingKey != null) {
            Assert.isTrue((boolean)this.routingKey.equals(routingKey), (String)"Cannot send with different routing keys in the same batch");
        } else {
            this.routingKey = routingKey;
        }
        int bufferUse = 4 + message.getBody().length;
        MessageBatch batch = null;
        if (this.messages.size() > 0 && this.currentSize + bufferUse > this.bufferLimit) {
            batch = this.releaseBatch();
            this.exchange = exchange;
            this.routingKey = routingKey;
        }
        this.currentSize += bufferUse;
        this.messages.add(message);
        if (batch == null && (this.messages.size() >= this.batchSize || this.currentSize >= this.bufferLimit)) {
            batch = this.releaseBatch();
        }
        return batch;
    }

    @Override
    public Date nextRelease() {
        if (this.messages.size() == 0 || this.timeout <= 0L) {
            return null;
        }
        if (this.currentSize >= this.bufferLimit) {
            return new Date();
        }
        return new Date(System.currentTimeMillis() + this.timeout);
    }

    @Override
    public MessageBatch releaseBatch() {
        if (this.messages.size() < 1) {
            return null;
        }
        Message message = this.assembleMessage();
        MessageBatch messageBatch = new MessageBatch(this.exchange, this.routingKey, message);
        this.messages.clear();
        this.currentSize = 0;
        this.exchange = null;
        this.routingKey = null;
        return messageBatch;
    }

    private Message assembleMessage() {
        if (this.messages.size() == 1) {
            return this.messages.get(0);
        }
        MessageProperties messageProperties = this.messages.get(0).getMessageProperties();
        byte[] body = new byte[this.currentSize];
        ByteBuffer bytes = ByteBuffer.wrap(body);
        for (Message message : this.messages) {
            bytes.putInt(message.getBody().length);
            bytes.put(message.getBody());
        }
        messageProperties.getHeaders().put("springBatchFormat", "lengthHeader4");
        return new Message(body, messageProperties);
    }
}

