/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.interceptor.StatefulRetryOperationsInterceptor;
import org.springframework.retry.support.RetryTemplate;

public class StatefulRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private static Log logger = LogFactory.getLog(StatefulRetryOperationsInterceptorFactoryBean.class);
    private MessageKeyGenerator messageKeyGenerator;
    private NewMessageIdentifier newMessageIdentifier;

    public void setMessageKeyGenerator(MessageKeyGenerator messageKeyGeneretor) {
        this.messageKeyGenerator = messageKeyGeneretor;
    }

    public void setNewMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
        this.newMessageIdentifier = newMessageIdentifier;
    }

    public StatefulRetryOperationsInterceptor getObject() {
        StatefulRetryOperationsInterceptor retryInterceptor = new StatefulRetryOperationsInterceptor();
        RetryOperations retryTemplate = this.getRetryOperations();
        if (retryTemplate == null) {
            retryTemplate = new RetryTemplate();
        }
        retryInterceptor.setRetryOperations(retryTemplate);
        retryInterceptor.setNewItemIdentifier(new NewMethodArgumentsIdentifier(){

            public boolean isNew(Object[] args) {
                Message message = (Message)args[1];
                if (StatefulRetryOperationsInterceptorFactoryBean.this.newMessageIdentifier == null) {
                    return message.getMessageProperties().isRedelivered() == false;
                }
                return StatefulRetryOperationsInterceptorFactoryBean.this.newMessageIdentifier.isNew(message);
            }
        });
        final MessageRecoverer messageRecoverer = this.getMessageRecoverer();
        retryInterceptor.setRecoverer((MethodInvocationRecoverer)new MethodInvocationRecoverer<Void>(){

            public Void recover(Object[] args, Throwable cause) {
                Message message = (Message)args[1];
                if (messageRecoverer == null) {
                    logger.warn((Object)("Message dropped on recovery: " + message), cause);
                } else {
                    messageRecoverer.recover(message, cause);
                }
                throw new ImmediateAcknowledgeAmqpException("Recovered message forces ack (if ack mode requires it): " + message, cause);
            }
        });
        retryInterceptor.setKeyGenerator(new MethodArgumentsKeyGenerator(){

            public Object getKey(Object[] args) {
                Message message = (Message)args[1];
                if (StatefulRetryOperationsInterceptorFactoryBean.this.messageKeyGenerator == null) {
                    String messageId = message.getMessageProperties().getMessageId();
                    if (messageId == null) {
                        throw new FatalListenerExecutionException("Illegal null id in message. Failed to manage retry for message: " + message);
                    }
                    return messageId;
                }
                return StatefulRetryOperationsInterceptorFactoryBean.this.messageKeyGenerator.getKey(message);
            }
        });
        return retryInterceptor;
    }

    public Class<?> getObjectType() {
        return StatefulRetryOperationsInterceptor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

