/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.AmqpUnsupportedEncodingException;
import org.springframework.amqp.UncategorizedAmqpException;
import org.springframework.util.Assert;

public class RabbitExceptionTranslator {
    public static RuntimeException convertRabbitAccessException(Throwable ex) {
        Assert.notNull((Object)ex, (String)"Exception must not be null");
        if (ex instanceof AmqpException) {
            return (AmqpException)ex;
        }
        if (ex instanceof ShutdownSignalException) {
            return new AmqpConnectException((Exception)((Object)((ShutdownSignalException)ex)));
        }
        if (ex instanceof ConnectException) {
            return new AmqpConnectException((Exception)((ConnectException)ex));
        }
        if (ex instanceof PossibleAuthenticationFailureException) {
            return new AmqpAuthenticationException(ex);
        }
        if (ex instanceof UnsupportedEncodingException) {
            return new AmqpUnsupportedEncodingException(ex);
        }
        if (ex instanceof IOException) {
            return new AmqpIOException((IOException)ex);
        }
        if (ex instanceof TimeoutException) {
            return new AmqpTimeoutException((Throwable)((IOException)ex));
        }
        return new UncategorizedAmqpException(ex);
    }
}

