/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private HandlerAdapter handlerMethod;
    private final MessagingMessageConverterAdapter messagingMessageConverter;

    public MessagingMessageListenerAdapter() {
        this(null, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(bean, method);
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    @Override
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        Object result;
        Message<?> message = this.toMessagingMessage(amqpMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        if ((result = this.invokeHandler(amqpMessage, channel, message)) != null) {
            this.handleResult(result, amqpMessage, channel, message);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    private Object invokeHandler(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            return this.handlerMethod.invoke(message, amqpMessage, channel);
        }
        catch (MessageConversionException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), (Throwable)new org.springframework.amqp.support.converter.MessageConversionException("Cannot handle message", (Throwable)ex));
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethodAsString(message.getPayload()) + "' threw exception", ex);
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\n" + "Endpoint handler details:\n" + "Method [" + this.handlerMethod.getMethodAsString(payload) + "]\n" + "Bean [" + this.handlerMethod.getBean() + "]";
    }

    @Override
    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof org.springframework.amqp.core.Message)) {
            throw new org.springframework.amqp.support.converter.MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (org.springframework.amqp.core.Message)result;
    }

    private final class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private final Object bean;
        private final Method method;
        private final Type inferredArgumentType;

        private MessagingMessageConverterAdapter(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            this.inferredArgumentType = this.determineInferredType();
            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled() && this.inferredArgumentType != null) {
                MessagingMessageListenerAdapter.this.logger.debug((Object)("Inferred argument type for " + method.toString() + " is " + this.inferredArgumentType));
            }
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            MessageProperties messageProperties = message.getMessageProperties();
            if (this.bean != null) {
                messageProperties.setTargetBean(this.bean);
            }
            if (this.method != null) {
                messageProperties.setTargetMethod(this.method);
                if (this.inferredArgumentType != null) {
                    messageProperties.setInferredArgumentType(this.inferredArgumentType);
                }
            }
            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }

        private Type determineInferredType() {
            if (this.method == null) {
                return null;
            }
            Type genericParameterType = null;
            for (int i = 0; i < this.method.getParameterTypes().length; ++i) {
                MethodParameter methodParameter = new MethodParameter(this.method, i);
                if (!this.isEligibleParameter(methodParameter) || methodParameter.getParameterAnnotations().length != 0 && !methodParameter.hasParameterAnnotation(Payload.class)) continue;
                if (genericParameterType == null) {
                    ParameterizedType parameterizedType;
                    genericParameterType = methodParameter.getGenericParameterType();
                    if (!(genericParameterType instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericParameterType).getRawType().equals(Message.class)) continue;
                    genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                    continue;
                }
                if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.debug((Object)("Ambiguous parameters for target payload for method " + this.method + "; no inferred type header added"));
                }
                return null;
            }
            return genericParameterType;
        }

        private boolean isEligibleParameter(MethodParameter methodParameter) {
            ParameterizedType parameterizedType;
            Type parameterType = methodParameter.getGenericParameterType();
            if (parameterType.equals(Channel.class) || parameterType.equals(org.springframework.amqp.core.Message.class)) {
                return false;
            }
            if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
                return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
            }
            return !parameterType.equals(Message.class);
        }
    }
}

