/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.Argument;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.annotation.RabbitListeners;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MultiMethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
SmartInitializingSingleton {
    public static final String DEFAULT_RABBIT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "rabbitListenerContainerFactory";
    public static final String RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY = "spring.rabbitmq.emptyStringArguments";
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> emptyStringArguments = new HashSet<String>();
    private RabbitListenerEndpointRegistry endpointRegistry;
    private String containerFactoryBeanName = "rabbitListenerContainerFactory";
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private final RabbitHandlerMethodFactoryAdapter messageHandlerMethodFactory = new RabbitHandlerMethodFactoryAdapter();
    private final RabbitListenerEndpointRegistrar registrar = new RabbitListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private final MultiValueMap<Class<?>, Method> methodCache = new LinkedMultiValueMap();
    private final MultiValueMap<Method, RabbitListener> annotationCache = new LinkedMultiValueMap();
    private final MultiValueMap<Class<?>, RabbitListener> classAnnotationCache = new LinkedMultiValueMap();
    private final Map<Class<?>, List<Method>> multiMethodCache = new LinkedHashMap();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private int increment;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public RabbitListenerAnnotationBeanPostProcessor() {
        this.emptyStringArguments.add("x-dead-letter-exchange");
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        String property = (String)environment.getProperty(RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY, String.class);
        if (property != null) {
            this.emptyStringArguments.addAll(StringUtils.commaDelimitedListToSet((String)property));
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RabbitListenerConfigurer.class);
            for (RabbitListenerConfigurer configurer : instances.values()) {
                configurer.configureRabbitListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (RabbitListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry", RabbitListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
        this.classAnnotationCache.clear();
        this.annotationCache.clear();
        this.methodCache.clear();
        this.multiMethodCache.clear();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.methodCache.get((Object)targetClass) == null) {
            this.findMethods(targetClass);
        }
        List classLevelListeners = (List)this.classAnnotationCache.get((Object)targetClass);
        List methods = (List)this.methodCache.get((Object)targetClass);
        List<Method> multiMethods = this.multiMethodCache.get(targetClass);
        for (Method method : methods) {
            List listenerAnnotations = (List)this.annotationCache.get((Object)method);
            if (listenerAnnotations == null) continue;
            for (RabbitListener rabbitListener : listenerAnnotations) {
                this.processAmqpListener(rabbitListener, method, bean, beanName);
            }
        }
        if (multiMethods.size() > 0) {
            this.processMultiMethodListeners(classLevelListeners, multiMethods, bean, beanName);
        }
        return bean;
    }

    private void findMethods(Class<?> targetClass) {
        Collection<RabbitListener> classLevelListeners = this.findListenerAnnotations(targetClass);
        boolean hasClassLevelListeners = classLevelListeners.size() > 0;
        LinkedMultiValueMap annotations = new LinkedMultiValueMap();
        final ArrayList methods = new ArrayList();
        ArrayList multiMethods = new ArrayList();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback((MultiValueMap)annotations, hasClassLevelListeners, multiMethods){
            final /* synthetic */ MultiValueMap val$annotations;
            final /* synthetic */ boolean val$hasClassLevelListeners;
            final /* synthetic */ List val$multiMethods;
            {
                this.val$annotations = multiValueMap;
                this.val$hasClassLevelListeners = bl;
                this.val$multiMethods = list2;
            }

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                RabbitHandler rabbitHandler;
                Collection listenerAnnotations = RabbitListenerAnnotationBeanPostProcessor.this.findListenerAnnotations(method);
                if (listenerAnnotations.size() > 0) {
                    methods.add(method);
                    this.val$annotations.put((Object)method, new ArrayList(listenerAnnotations));
                }
                if (this.val$hasClassLevelListeners && (rabbitHandler = (RabbitHandler)AnnotationUtils.findAnnotation((Method)method, RabbitHandler.class)) != null) {
                    this.val$multiMethods.add(method);
                }
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        this.methodCache.put(targetClass, methods);
        for (Method method : methods) {
            this.annotationCache.put((Object)method, annotations.get((Object)method));
        }
        this.classAnnotationCache.put(targetClass, new ArrayList<RabbitListener>(classLevelListeners));
        this.multiMethodCache.put(targetClass, multiMethods);
    }

    private Collection<RabbitListener> findListenerAnnotations(Class<?> clazz) {
        RabbitListeners anns;
        HashSet<RabbitListener> listeners = new HashSet<RabbitListener>();
        RabbitListener ann = (RabbitListener)AnnotationUtils.findAnnotation(clazz, RabbitListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (RabbitListeners)AnnotationUtils.findAnnotation(clazz, RabbitListeners.class)) != null) {
            listeners.addAll(Arrays.asList(anns.value()));
        }
        return listeners;
    }

    private Collection<RabbitListener> findListenerAnnotations(Method method) {
        RabbitListeners anns;
        HashSet<RabbitListener> listeners = new HashSet<RabbitListener>();
        RabbitListener ann = (RabbitListener)AnnotationUtils.findAnnotation((Method)method, RabbitListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (RabbitListeners)AnnotationUtils.findAnnotation((Method)method, RabbitListeners.class)) != null) {
            listeners.addAll(Arrays.asList(anns.value()));
        }
        return listeners;
    }

    private void processMultiMethodListeners(Collection<RabbitListener> classLevelListeners, List<Method> multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        for (Method method : multiMethods) {
            checkedMethods.add(this.checkProxy(method, bean));
        }
        for (RabbitListener classLevelListener : classLevelListeners) {
            MultiMethodRabbitListenerEndpoint endpoint = new MultiMethodRabbitListenerEndpoint(checkedMethods, bean);
            endpoint.setBeanFactory(this.beanFactory);
            this.processListener(endpoint, classLevelListener, bean, bean.getClass(), beanName);
        }
    }

    protected void processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodRabbitListenerEndpoint endpoint = new MethodRabbitListenerEndpoint();
        endpoint.setMethod(methodToUse);
        endpoint.setBeanFactory(this.beanFactory);
        this.processListener(endpoint, rabbitListener, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method method, Object bean) {
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@RabbitListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
        }
        return method;
    }

    protected void processListener(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object bean, Object adminTarget, String beanName) {
        String rabbitAdmin;
        Object resolvedGroup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(rabbitListener));
        endpoint.setQueueNames(this.resolveQueues(rabbitListener));
        String group = rabbitListener.group();
        if (StringUtils.hasText((String)group) && (resolvedGroup = this.resolveExpression(group)) instanceof String) {
            endpoint.setGroup((String)resolvedGroup);
        }
        endpoint.setExclusive(rabbitListener.exclusive());
        String priority = this.resolve(rabbitListener.priority());
        if (StringUtils.hasText((String)priority)) {
            try {
                endpoint.setPriority(Integer.valueOf(priority));
            }
            catch (NumberFormatException ex) {
                throw new BeanInitializationException("Invalid priority value for " + rabbitListener + " (must be an integer)", (Throwable)ex);
            }
        }
        if (StringUtils.hasText((String)(rabbitAdmin = this.resolve(rabbitListener.admin())))) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve RabbitAdmin by bean name");
            try {
                endpoint.setAdmin((RabbitAdmin)this.beanFactory.getBean(rabbitAdmin, RabbitAdmin.class));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register rabbit listener endpoint on [" + adminTarget + "], no " + RabbitAdmin.class.getSimpleName() + " with id '" + rabbitAdmin + "' was found in the application context", (Throwable)ex);
            }
        }
        RabbitListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(rabbitListener.containerFactory());
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (RabbitListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, RabbitListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register rabbit listener endpoint on [" + adminTarget + "] for bean " + beanName + ", no " + RabbitListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    private String getEndpointId(RabbitListener rabbitListener) {
        if (StringUtils.hasText((String)rabbitListener.id())) {
            return this.resolve(rabbitListener.id());
        }
        return "org.springframework.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String[] resolveQueues(RabbitListener rabbitListener) {
        String[] queues = rabbitListener.queues();
        QueueBinding[] bindings = rabbitListener.bindings();
        if (queues.length > 0 && bindings.length > 0) {
            throw new BeanInitializationException("@RabbitListener can have 'queues' or 'bindings' but not both");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (queues.length > 0) {
            for (int i = 0; i < queues.length; ++i) {
                Object resolvedValue = this.resolveExpression(queues[i]);
                this.resolveAsString(resolvedValue, result);
            }
        } else {
            return this.registerBeansForDeclaration(rabbitListener);
        }
        return result.toArray(new String[result.size()]);
    }

    private void resolveAsString(Object resolvedValue, List<String> result) {
        List<String> resolvedValueToUse = resolvedValue;
        if (resolvedValue instanceof String[]) {
            resolvedValueToUse = Arrays.asList((String[])resolvedValue);
        }
        if (resolvedValueToUse instanceof org.springframework.amqp.core.Queue) {
            result.add(((org.springframework.amqp.core.Queue)resolvedValueToUse).getName());
        } else if (resolvedValueToUse instanceof String) {
            result.add((String)((Object)resolvedValueToUse));
        } else if (resolvedValueToUse instanceof Iterable) {
            for (Object object : (Iterable)resolvedValueToUse) {
                this.resolveAsString(object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@RabbitListener can't resolve '%s' as either a String or a Queue", resolvedValue));
        }
    }

    private String[] registerBeansForDeclaration(RabbitListener rabbitListener) {
        ArrayList<String> queues = new ArrayList<String>();
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            for (QueueBinding binding : rabbitListener.bindings()) {
                String queueName = this.declareQueue(binding);
                queues.add(queueName);
                this.declareExchangeAndBinding(binding, queueName);
            }
        }
        return queues.toArray(new String[queues.size()]);
    }

    private String declareQueue(QueueBinding binding) {
        Queue bindingQueue = binding.value();
        String queueName = (String)this.resolveExpression(bindingQueue.value());
        boolean exclusive = false;
        boolean autoDelete = false;
        if (!StringUtils.hasText((String)queueName)) {
            queueName = UUID.randomUUID().toString();
            if (!StringUtils.hasText((String)bindingQueue.exclusive()) || this.resolveExpressionAsBoolean(bindingQueue.exclusive())) {
                exclusive = true;
            }
            if (!StringUtils.hasText((String)bindingQueue.autoDelete()) || this.resolveExpressionAsBoolean(bindingQueue.autoDelete())) {
                autoDelete = true;
            }
        } else {
            exclusive = this.resolveExpressionAsBoolean(bindingQueue.exclusive());
            autoDelete = this.resolveExpressionAsBoolean(bindingQueue.autoDelete());
        }
        org.springframework.amqp.core.Queue queue = new org.springframework.amqp.core.Queue(queueName, this.resolveExpressionAsBoolean(bindingQueue.durable()), exclusive, autoDelete, this.resolveArguments(bindingQueue.arguments()));
        queue.setIgnoreDeclarationExceptions(this.resolveExpressionAsBoolean(bindingQueue.ignoreDeclarationExceptions()));
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(queueName + ++this.increment, (Object)queue);
        return queueName;
    }

    private void declareExchangeAndBinding(QueueBinding binding, String queueName) {
        Binding actualBinding;
        org.springframework.amqp.core.Exchange exchange;
        Exchange bindingExchange = binding.exchange();
        String exchangeName = this.resolveExpressionAsString(bindingExchange.value(), "@Exchange.exchange");
        String exchangeType = this.resolveExpressionAsString(bindingExchange.type(), "@Exchange.type");
        String routingKey = this.resolveExpressionAsString(binding.key(), "@QueueBinding.key");
        if (exchangeType.equals("direct")) {
            exchange = this.directExchange(bindingExchange, exchangeName);
            actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, this.resolveArguments(binding.arguments()));
        } else if (exchangeType.equals("fanout")) {
            exchange = this.fanoutExchange(bindingExchange, exchangeName);
            actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, "", this.resolveArguments(binding.arguments()));
        } else if (exchangeType.equals("topic")) {
            exchange = this.topicExchange(bindingExchange, exchangeName);
            actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, this.resolveArguments(binding.arguments()));
        } else if (exchangeType.equals("headers")) {
            exchange = this.headersExchange(bindingExchange, exchangeName);
            actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, this.resolveArguments(binding.arguments()));
        } else {
            throw new BeanInitializationException("Unexpected exchange type: " + exchangeType);
        }
        AbstractExchange abstractExchange = (AbstractExchange)exchange;
        abstractExchange.setInternal(this.resolveExpressionAsBoolean(bindingExchange.internal()));
        abstractExchange.setDelayed(this.resolveExpressionAsBoolean(bindingExchange.delayed()));
        abstractExchange.setIgnoreDeclarationExceptions(this.resolveExpressionAsBoolean(bindingExchange.ignoreDeclarationExceptions()));
        actualBinding.setIgnoreDeclarationExceptions(this.resolveExpressionAsBoolean(binding.ignoreDeclarationExceptions()));
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + ++this.increment, (Object)exchange);
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + "." + queueName + ++this.increment, (Object)actualBinding);
    }

    private org.springframework.amqp.core.Exchange directExchange(Exchange bindingExchange, String exchangeName) {
        return new DirectExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()), this.resolveArguments(bindingExchange.arguments()));
    }

    private org.springframework.amqp.core.Exchange fanoutExchange(Exchange bindingExchange, String exchangeName) {
        return new FanoutExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()), this.resolveArguments(bindingExchange.arguments()));
    }

    private org.springframework.amqp.core.Exchange topicExchange(Exchange bindingExchange, String exchangeName) {
        return new TopicExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()), this.resolveArguments(bindingExchange.arguments()));
    }

    private org.springframework.amqp.core.Exchange headersExchange(Exchange bindingExchange, String exchangeName) {
        return new HeadersExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()), this.resolveArguments(bindingExchange.arguments()));
    }

    private Map<String, Object> resolveArguments(Argument[] arguments) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Argument arg : arguments) {
            String key = this.resolveExpressionAsString(arg.name(), "@Argument.name");
            if (StringUtils.hasText((String)key)) {
                String typeName;
                Class typeClass;
                Object value = this.resolveExpression(arg.value());
                Object type = this.resolveExpression(arg.type());
                if (type instanceof Class) {
                    typeClass = (Class)type;
                    typeName = typeClass.getName();
                } else {
                    Assert.isTrue((boolean)(type instanceof String), (String)("Type must resolve to a Class or String, but resolved to [" + type.getClass().getName() + "]"));
                    typeName = (String)type;
                    try {
                        typeClass = ClassUtils.forName((String)typeName, (ClassLoader)this.beanClassLoader);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not load class", e);
                    }
                }
                this.addToMap(map, key, value, typeClass, typeName);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)"@Argument ignored because the name resolved to an empty String");
        }
        return map.size() < 1 ? null : map;
    }

    private void addToMap(Map<String, Object> map, String key, Object value, Class<?> typeClass, String typeName) {
        if (value.getClass().getName().equals(typeName)) {
            if (typeClass.equals(String.class) && !StringUtils.hasText((String)((String)value))) {
                this.putEmpty(map, key);
            } else {
                map.put(key, value);
            }
        } else if (value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.putEmpty(map, key);
        } else if (CONVERSION_SERVICE.canConvert(value.getClass(), typeClass)) {
            map.put(key, CONVERSION_SERVICE.convert(value, typeClass));
        } else {
            throw new IllegalStateException("Cannot convert from " + value.getClass().getName() + " to " + typeName);
        }
    }

    private void putEmpty(Map<String, Object> map, String key) {
        if (this.emptyStringArguments.contains(key)) {
            map.put(key, "");
        } else {
            map.put(key, null);
        }
    }

    private boolean resolveExpressionAsBoolean(String value) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof Boolean) {
            return (Boolean)resolved;
        }
        if (resolved instanceof String) {
            return Boolean.valueOf((String)resolved);
        }
        return false;
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        if (!resolvedValue.startsWith("#{") || !value.endsWith("}")) {
            return resolvedValue;
        }
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private class RabbitHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private RabbitHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory1) {
            this.messageHandlerMethodFactory = rabbitHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(RabbitListenerAnnotationBeanPostProcessor.this.beanFactory);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

