/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ActiveObjectCounter<T> {
    private final ConcurrentMap<T, CountDownLatch> locks = new ConcurrentHashMap<T, CountDownLatch>();
    private volatile boolean active = true;

    public void add(T object) {
        CountDownLatch lock = new CountDownLatch(1);
        this.locks.putIfAbsent(object, lock);
    }

    public void release(T object) {
        CountDownLatch remove = (CountDownLatch)this.locks.remove(object);
        if (remove != null) {
            remove.countDown();
        }
    }

    public boolean await(Long timeout, TimeUnit timeUnit) throws InterruptedException {
        long t0 = System.currentTimeMillis();
        long t1 = t0 + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        while (System.currentTimeMillis() <= t1) {
            if (this.locks.isEmpty()) {
                return true;
            }
            HashSet objects = new HashSet(this.locks.keySet());
            for (Object object : objects) {
                CountDownLatch lock = (CountDownLatch)this.locks.get(object);
                if (lock == null || !lock.await(t1 - (t0 = System.currentTimeMillis()), TimeUnit.MILLISECONDS)) continue;
                this.locks.remove(object);
            }
        }
        return false;
    }

    public int getCount() {
        return this.locks.size();
    }

    public void reset() {
        this.locks.clear();
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

