/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.springframework.amqp.AmqpApplicationContextClosedException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionProxy;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannelConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.support.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannelImpl;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ManagedResource
public class CachingConnectionFactory
extends AbstractConnectionFactory
implements InitializingBean,
ShutdownListener,
PublisherCallbackChannelConnectionFactory {
    private static final int DEFAULT_CHANNEL_CACHE_SIZE = 25;
    private static final String DEFAULT_DEFERRED_POOL_PREFIX = "spring-rabbit-deferred-pool-";
    private static final AtomicInteger threadPoolId = new AtomicInteger();
    private static final Set<String> txStarts = new HashSet<String>(Arrays.asList("basicPublish", "basicAck", "basicNack", "basicReject"));
    private static final Set<String> ackMethods = new HashSet<String>(Arrays.asList("basicAck", "basicNack", "basicReject"));
    private static final Set<String> txEnds = new HashSet<String>(Arrays.asList("txCommit", "txRollback"));
    private final ChannelCachingConnectionProxy connection = new ChannelCachingConnectionProxy(null);
    private final Set<ChannelCachingConnectionProxy> allocatedConnections = new HashSet<ChannelCachingConnectionProxy>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionNonTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final BlockingDeque<ChannelCachingConnectionProxy> idleConnections = new LinkedBlockingDeque<ChannelCachingConnectionProxy>();
    private final LinkedList<ChannelProxy> cachedChannelsNonTransactional = new LinkedList();
    private final LinkedList<ChannelProxy> cachedChannelsTransactional = new LinkedList();
    private final Map<Connection, Semaphore> checkoutPermits = new HashMap<Connection, Semaphore>();
    private final Map<String, AtomicInteger> channelHighWaterMarks = new HashMap<String, AtomicInteger>();
    private final AtomicInteger connectionHighWaterMark = new AtomicInteger();
    private final CachingConnectionFactory publisherConnectionFactory;
    private volatile long channelCheckoutTimeout = 0L;
    private volatile CacheMode cacheMode = CacheMode.CHANNEL;
    private volatile int channelCacheSize = 25;
    private volatile int connectionCacheSize = 1;
    private volatile int connectionLimit = Integer.MAX_VALUE;
    private volatile boolean active = true;
    private volatile boolean publisherConfirms;
    private volatile boolean publisherReturns;
    private volatile boolean initialized;
    private volatile boolean stopped;
    private volatile ConditionalExceptionLogger closeExceptionLogger = new DefaultChannelCloseLogger();
    private final Object connectionMonitor = new Object();
    private ExecutorService deferredCloseExecutor;

    public CachingConnectionFactory() {
        this((String)null);
    }

    public CachingConnectionFactory(String hostname) {
        this(hostname, 5672);
    }

    public CachingConnectionFactory(int port) {
        this(null, port);
    }

    public CachingConnectionFactory(String hostname, int port) {
        super(CachingConnectionFactory.newRabbitConnectionFactory());
        if (!StringUtils.hasText((String)hostname)) {
            hostname = this.getDefaultHostName();
        }
        this.setHost(hostname);
        this.setPort(port);
        this.publisherConnectionFactory = new CachingConnectionFactory(this.getRabbitConnectionFactory(), true);
        this.setPublisherConnectionFactory(this.publisherConnectionFactory);
    }

    public CachingConnectionFactory(URI uri) {
        super(CachingConnectionFactory.newRabbitConnectionFactory());
        this.setUri(uri);
        this.publisherConnectionFactory = new CachingConnectionFactory(this.getRabbitConnectionFactory(), true);
        this.setPublisherConnectionFactory(this.publisherConnectionFactory);
    }

    public CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory, boolean isPublisherFactory) {
        super(rabbitConnectionFactory);
        if (!isPublisherFactory) {
            if (rabbitConnectionFactory.isAutomaticRecoveryEnabled()) {
                this.logger.warn((Object)"***\nAutomatic Recovery is Enabled in the provided connection factory;\nwhile Spring AMQP is compatible with this feature, it\nprefers to use its own recovery mechanisms; when this option is true, you may receive\n'AutoRecoverConnectionNotCurrentlyOpenException's until the connection is recovered.");
            }
            this.publisherConnectionFactory = new CachingConnectionFactory(this.getRabbitConnectionFactory(), true);
            this.setPublisherConnectionFactory(this.publisherConnectionFactory);
        } else {
            this.publisherConnectionFactory = null;
        }
    }

    private static ConnectionFactory newRabbitConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setAutomaticRecoveryEnabled(false);
        return connectionFactory;
    }

    public void setChannelCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Channel cache size must be 1 or higher");
        this.channelCacheSize = sessionCacheSize;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setChannelCacheSize(sessionCacheSize);
        }
    }

    public int getChannelCacheSize() {
        return this.channelCacheSize;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'cacheMode' cannot be changed after initialization.");
        Assert.notNull((Object)((Object)cacheMode), (String)"'cacheMode' must not be null.");
        this.cacheMode = cacheMode;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setCacheMode(cacheMode);
        }
    }

    public int getConnectionCacheSize() {
        return this.connectionCacheSize;
    }

    public void setConnectionCacheSize(int connectionCacheSize) {
        Assert.isTrue((connectionCacheSize >= 1 ? 1 : 0) != 0, (String)"Connection cache size must be 1 or higher.");
        this.connectionCacheSize = connectionCacheSize;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setConnectionCacheSize(connectionCacheSize);
        }
    }

    public void setConnectionLimit(int connectionLimit) {
        Assert.isTrue((connectionLimit >= 1 ? 1 : 0) != 0, (String)"Connection limit must be 1 or higher.");
        this.connectionLimit = connectionLimit;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setConnectionLimit(connectionLimit);
        }
    }

    @Override
    public boolean isPublisherConfirms() {
        return this.publisherConfirms;
    }

    @Override
    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setPublisherReturns(publisherReturns);
        }
    }

    public void setPublisherConfirms(boolean publisherConfirms) {
        this.publisherConfirms = publisherConfirms;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setPublisherConfirms(publisherConfirms);
        }
    }

    public void setChannelCheckoutTimeout(long channelCheckoutTimeout) {
        this.channelCheckoutTimeout = channelCheckoutTimeout;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setChannelCheckoutTimeout(channelCheckoutTimeout);
        }
    }

    public void setCloseExceptionLogger(ConditionalExceptionLogger closeExceptionLogger) {
        Assert.notNull((Object)closeExceptionLogger, (String)"'closeExceptionLogger' cannot be null");
        this.closeExceptionLogger = closeExceptionLogger;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setCloseExceptionLogger(closeExceptionLogger);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initialized = true;
        if (this.cacheMode == CacheMode.CHANNEL) {
            Assert.isTrue((this.connectionCacheSize == 1 ? 1 : 0) != 0, (String)"When the cache mode is 'CHANNEL', the connection cache size cannot be configured.");
        }
        this.initCacheWaterMarks();
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.afterPropertiesSet();
        }
    }

    private void initCacheWaterMarks() {
        this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.cachedChannelsNonTransactional), new AtomicInteger());
        this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.cachedChannelsTransactional), new AtomicInteger());
    }

    @Override
    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        super.setConnectionListeners(listeners);
        if (this.connection.target != null) {
            this.getConnectionListener().onCreate(this.connection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        if (this.connection.target != null) {
            listener.onCreate(this.connection);
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        this.closeExceptionLogger.log(this.logger, "Channel shutdown", (Throwable)cause);
        int protocolClassId = cause.getReason().protocolClassId();
        if (protocolClassId == 20) {
            this.getChannelListener().onShutDown(cause);
        } else if (protocolClassId == 10) {
            this.getConnectionListener().onShutDown(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        LinkedList<ChannelProxy> channelList;
        Semaphore checkoutPermits = null;
        if (this.channelCheckoutTimeout > 0L) {
            checkoutPermits = this.checkoutPermits.get(connection);
            if (checkoutPermits == null) throw new IllegalStateException("No permits map entry for " + connection);
            try {
                if (!checkoutPermits.tryAcquire(this.channelCheckoutTimeout, TimeUnit.MILLISECONDS)) {
                    throw new AmqpTimeoutException("No available channels");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired permit for " + connection + ", remaining:" + checkoutPermits.availablePermits()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AmqpTimeoutException("Interrupted while acquiring a channel", (Throwable)e);
            }
        }
        if (this.cacheMode == CacheMode.CHANNEL) {
            channelList = transactional ? this.cachedChannelsTransactional : this.cachedChannelsNonTransactional;
        } else {
            LinkedList<ChannelProxy> linkedList = channelList = transactional ? this.allocatedConnectionTransactionalChannels.get(connection) : this.allocatedConnectionNonTransactionalChannels.get(connection);
        }
        if (channelList == null) {
            throw new IllegalStateException("No channel list for connection " + connection);
        }
        ChannelProxy channel = null;
        if (connection.isOpen()) {
            LinkedList<ChannelProxy> linkedList = channelList;
            synchronized (linkedList) {
                while (!channelList.isEmpty()) {
                    block24: {
                        channel = channelList.removeFirst();
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)(channel + " retrieved from cache"));
                        }
                        if (channel.isOpen()) break;
                        try {
                            Channel target = channel.getTargetChannel();
                            if (target != null) {
                                target.close();
                            }
                        }
                        catch (AlreadyClosedException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)(channel + " is already closed"));
                            }
                        }
                        catch (IOException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Unexpected Exception closing channel " + e.getMessage()));
                            }
                        }
                        catch (TimeoutException e) {
                            if (!this.logger.isWarnEnabled()) break block24;
                            this.logger.warn((Object)("TimeoutException closing channel " + e.getMessage()));
                        }
                    }
                    channel = null;
                }
            }
            if (channel != null && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found cached Rabbit Channel: " + channel.toString()));
            }
        }
        if (channel != null) return channel;
        try {
            return this.getCachedChannelProxy(connection, channelList, transactional);
        }
        catch (RuntimeException e) {
            if (checkoutPermits == null) throw e;
            checkoutPermits.release();
            if (!this.logger.isDebugEnabled()) throw e;
            this.logger.debug((Object)("Could not get channel; released permit for " + connection + ", remaining:" + checkoutPermits.availablePermits()));
            throw e;
        }
    }

    private ChannelProxy getCachedChannelProxy(ChannelCachingConnectionProxy connection, LinkedList<ChannelProxy> channelList, boolean transactional) {
        Channel targetChannel = this.createBareChannel(connection, transactional);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating cached Rabbit Channel from " + targetChannel));
        }
        this.getChannelListener().onCreate(targetChannel, transactional);
        Class[] interfaces = this.publisherConfirms || this.publisherReturns ? new Class[]{ChannelProxy.class, PublisherCallbackChannel.class} : new Class[]{ChannelProxy.class};
        return (ChannelProxy)Proxy.newProxyInstance(ChannelProxy.class.getClassLoader(), interfaces, (InvocationHandler)new CachedChannelInvocationHandler(connection, targetChannel, channelList, transactional));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel createBareChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        if (this.cacheMode == CacheMode.CHANNEL) {
            if (!this.connection.isOpen()) {
                Object object = this.connectionMonitor;
                synchronized (object) {
                    if (!this.connection.isOpen()) {
                        this.connection.notifyCloseIfNecessary();
                    }
                    if (!this.connection.isOpen()) {
                        this.connection.target = null;
                        this.createConnection();
                    }
                }
            }
            return this.doCreateBareChannel(this.connection, transactional);
        }
        if (this.cacheMode == CacheMode.CONNECTION) {
            if (!connection.isOpen()) {
                Object object = this.connectionMonitor;
                synchronized (object) {
                    this.allocatedConnectionNonTransactionalChannels.get(connection).clear();
                    this.allocatedConnectionTransactionalChannels.get(connection).clear();
                    connection.notifyCloseIfNecessary();
                    this.refreshProxyConnection(connection);
                }
            }
            return this.doCreateBareChannel(connection, transactional);
        }
        return null;
    }

    private Channel doCreateBareChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        Channel channel = connection.createBareChannel(transactional);
        if (this.publisherConfirms) {
            try {
                channel.confirmSelect();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not configure the channel to receive publisher confirms", (Throwable)e);
            }
        }
        if ((this.publisherConfirms || this.publisherReturns) && !(channel instanceof PublisherCallbackChannelImpl)) {
            channel = new PublisherCallbackChannelImpl(channel);
        }
        if (channel != null) {
            channel.addShutdownListener((ShutdownListener)this);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Connection createConnection() throws AmqpException {
        if (this.stopped) {
            throw new AmqpApplicationContextClosedException("The ApplicationContext is closed and the ConnectionFactory can no longer create connections.");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.cacheMode == CacheMode.CHANNEL) {
                if (this.connection.target == null) {
                    this.connection.target = super.createBareConnection();
                    if (!this.checkoutPermits.containsKey(this.connection)) {
                        this.checkoutPermits.put(this.connection, new Semaphore(this.channelCacheSize));
                    }
                    this.connection.closeNotified.set(false);
                    this.getConnectionListener().onCreate(this.connection);
                }
                return this.connection;
            }
            if (this.cacheMode == CacheMode.CONNECTION) {
                ChannelCachingConnectionProxy connection = this.findIdleConnection();
                long now = System.currentTimeMillis();
                if (connection == null && this.countOpenConnections() >= this.connectionLimit) {
                    while (connection == null && System.currentTimeMillis() - now < this.channelCheckoutTimeout) {
                        if (this.countOpenConnections() < this.connectionLimit) continue;
                        try {
                            this.connectionMonitor.wait(this.channelCheckoutTimeout);
                            connection = this.findIdleConnection();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new AmqpException("Interrupted while waiting for a connection", (Throwable)e);
                        }
                    }
                }
                if (connection == null) {
                    if (this.countOpenConnections() >= this.connectionLimit && System.currentTimeMillis() - now >= this.channelCheckoutTimeout) {
                        throw new AmqpTimeoutException("Timed out attempting to get a connection");
                    }
                    connection = new ChannelCachingConnectionProxy(super.createBareConnection());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding new connection '" + connection + "'"));
                    }
                    this.allocatedConnections.add(connection);
                    this.allocatedConnectionNonTransactionalChannels.put(connection, new LinkedList());
                    this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.allocatedConnectionNonTransactionalChannels.get(connection)), new AtomicInteger());
                    this.allocatedConnectionTransactionalChannels.put(connection, new LinkedList());
                    this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.allocatedConnectionTransactionalChannels.get(connection)), new AtomicInteger());
                    this.checkoutPermits.put(connection, new Semaphore(this.channelCacheSize));
                    this.getConnectionListener().onCreate(connection);
                } else if (!connection.isOpen()) {
                    try {
                        this.refreshProxyConnection(connection);
                    }
                    catch (Exception e) {
                        this.idleConnections.addLast(connection);
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Obtained connection '" + connection + "' from cache"));
                }
                return connection;
            }
        }
        return null;
    }

    private ChannelCachingConnectionProxy findIdleConnection() {
        ChannelCachingConnectionProxy connection = null;
        ChannelCachingConnectionProxy lastIdle = (ChannelCachingConnectionProxy)this.idleConnections.peekLast();
        while (connection == null && (connection = this.idleConnections.poll()) != null) {
            if (connection.isOpen()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping closed connection '" + connection + "'"));
            }
            connection.notifyCloseIfNecessary();
            this.idleConnections.addLast(connection);
            if (connection.equals(lastIdle)) {
                connection = this.idleConnections.poll();
                break;
            }
            connection = null;
        }
        return connection;
    }

    private void refreshProxyConnection(ChannelCachingConnectionProxy connection) {
        connection.destroy();
        connection.notifyCloseIfNecessary();
        connection.target = super.createBareConnection();
        connection.closeNotified.set(false);
        this.getConnectionListener().onCreate(connection);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshed existing connection '" + connection + "'"));
        }
    }

    @Override
    public final void destroy() {
        super.destroy();
        this.resetConnection();
        if (this.getContextStopped()) {
            this.stopped = true;
            if (this.deferredCloseExecutor != null) {
                this.deferredCloseExecutor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection.target != null) {
                this.connection.destroy();
            }
            for (ChannelCachingConnectionProxy connection : this.allocatedConnections) {
                connection.destroy();
            }
            for (AtomicInteger count : this.channelHighWaterMarks.values()) {
                count.set(0);
            }
            this.connectionHighWaterMark.set(0);
        }
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.resetConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(List<ChannelProxy> channels, List<ChannelProxy> txChannels) {
        this.active = false;
        List<ChannelProxy> list = channels;
        synchronized (list) {
            for (ChannelProxy channel : channels) {
                try {
                    channel.close();
                }
                catch (Exception ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", (Throwable)ex);
                }
            }
            channels.clear();
        }
        list = txChannels;
        synchronized (list) {
            for (ChannelProxy channel : txChannels) {
                try {
                    channel.close();
                }
                catch (Exception ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", (Throwable)ex);
                }
            }
            txChannels.clear();
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public Properties getCacheProperties() {
        Properties props = new Properties();
        props.setProperty("cacheMode", this.cacheMode.name());
        Object object = this.connectionMonitor;
        synchronized (object) {
            props.setProperty("channelCacheSize", Integer.toString(this.channelCacheSize));
            if (this.cacheMode.equals((Object)CacheMode.CONNECTION)) {
                LinkedList channelList;
                int port;
                props.setProperty("connectionCacheSize", Integer.toString(this.connectionCacheSize));
                props.setProperty("openConnections", Integer.toString(this.countOpenConnections()));
                props.setProperty("idleConnections", Integer.toString(this.idleConnections.size()));
                props.setProperty("idleConnectionsHighWater", Integer.toString(this.connectionHighWaterMark.get()));
                for (ChannelCachingConnectionProxy channelCachingConnectionProxy : this.allocatedConnections) {
                    this.putConnectionName(props, channelCachingConnectionProxy, ":" + channelCachingConnectionProxy.getLocalPort());
                }
                for (Map.Entry entry : this.allocatedConnectionTransactionalChannels.entrySet()) {
                    port = ((ChannelCachingConnectionProxy)entry.getKey()).getLocalPort();
                    if (port <= 0 || !((ChannelCachingConnectionProxy)entry.getKey()).isOpen()) continue;
                    channelList = (LinkedList)entry.getValue();
                    props.put("idleChannelsTx:" + port, Integer.toString(channelList.size()));
                    props.put("idleChannelsTxHighWater:" + port, Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString((Object)channelList)).get()));
                }
                for (Map.Entry entry : this.allocatedConnectionNonTransactionalChannels.entrySet()) {
                    port = ((ChannelCachingConnectionProxy)entry.getKey()).getLocalPort();
                    if (port <= 0 || !((ChannelCachingConnectionProxy)entry.getKey()).isOpen()) continue;
                    channelList = (LinkedList)entry.getValue();
                    props.put("idleChannelsNotTx:" + port, Integer.toString(channelList.size()));
                    props.put("idleChannelsNotTxHighWater:" + port, Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString((Object)channelList)).get()));
                }
            } else {
                props.setProperty("localPort", Integer.toString(this.connection.target == null ? 0 : this.connection.getLocalPort()));
                props.setProperty("idleChannelsTx", Integer.toString(this.cachedChannelsTransactional.size()));
                props.setProperty("idleChannelsNotTx", Integer.toString(this.cachedChannelsNonTransactional.size()));
                props.setProperty("idleChannelsTxHighWater", Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString(this.cachedChannelsTransactional)).get()));
                props.setProperty("idleChannelsNotTxHighWater", Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString(this.cachedChannelsNonTransactional)).get()));
                this.putConnectionName(props, this.connection, "");
            }
        }
        return props;
    }

    @ManagedAttribute
    public Properties getPublisherConnectionFactoryCacheProperties() {
        if (this.publisherConnectionFactory != null) {
            return this.publisherConnectionFactory.getCacheProperties();
        }
        return new Properties();
    }

    private void putConnectionName(Properties props, ConnectionProxy connection, String keySuffix) {
        String name;
        com.rabbitmq.client.Connection delegate;
        Connection targetConnection = connection.getTargetConnection();
        if (targetConnection != null && (delegate = targetConnection.getDelegate()) != null && (name = delegate.getClientProvidedName()) != null) {
            props.put("connectionName" + keySuffix, name);
        }
    }

    private int countOpenConnections() {
        int n = 0;
        for (ChannelCachingConnectionProxy proxy : this.allocatedConnections) {
            if (!proxy.isOpen()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getDeferredCloseExecutor() {
        if (this.getExecutorService() != null) {
            return this.getExecutorService();
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.deferredCloseExecutor == null) {
                String threadPrefix = this.getBeanName() == null ? DEFAULT_DEFERRED_POOL_PREFIX + threadPoolId.incrementAndGet() : this.getBeanName();
                CustomizableThreadFactory threadPoolFactory = new CustomizableThreadFactory(threadPrefix);
                this.deferredCloseExecutor = Executors.newCachedThreadPool((ThreadFactory)threadPoolFactory);
            }
        }
        return this.deferredCloseExecutor;
    }

    @Override
    public String toString() {
        return "CachingConnectionFactory [channelCacheSize=" + this.channelCacheSize + ", host=" + this.getHost() + ", port=" + this.getPort() + ", active=" + this.active + " " + super.toString() + "]";
    }

    private static class DefaultChannelCloseLogger
    implements ConditionalExceptionLogger {
        DefaultChannelCloseLogger() {
        }

        public void log(Log logger, String message, Throwable t) {
            if (t instanceof ShutdownSignalException) {
                ShutdownSignalException cause = (ShutdownSignalException)t;
                if (RabbitUtils.isPassiveDeclarationChannelClose(cause)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(message + ": " + cause.getMessage()));
                    }
                } else if (RabbitUtils.isExclusiveUseChannelClose(cause)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(message + ": " + cause.getMessage()));
                    }
                } else if (!RabbitUtils.isNormalChannelClose(cause)) {
                    logger.error((Object)(message + ": " + cause.getMessage()));
                }
            } else {
                logger.error((Object)("Unexpected invocation of " + this.getClass() + ", with message: " + message), t);
            }
        }
    }

    private class ChannelCachingConnectionProxy
    implements ConnectionProxy {
        private final AtomicBoolean closeNotified = new AtomicBoolean(false);
        private volatile Connection target;

        ChannelCachingConnectionProxy(Connection target) {
            this.target = target;
        }

        private Channel createBareChannel(boolean transactional) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't create channel - no target connection.");
            return this.target.createChannel(transactional);
        }

        @Override
        public Channel createChannel(boolean transactional) {
            return CachingConnectionFactory.this.getChannel(this, transactional);
        }

        @Override
        public void addBlockedListener(BlockedListener listener) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't add blocked listener - no target connection.");
            this.target.addBlockedListener(listener);
        }

        @Override
        public boolean removeBlockedListener(BlockedListener listener) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't remove blocked listener - no target connection.");
            return this.target.removeBlockedListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CONNECTION) {
                Object object = CachingConnectionFactory.this.connectionMonitor;
                synchronized (object) {
                    if (!CachingConnectionFactory.this.idleConnections.contains(this)) {
                        if (!this.isOpen() || this.countOpenIdleConnections() >= CachingConnectionFactory.this.connectionCacheSize) {
                            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                                CachingConnectionFactory.this.logger.debug((Object)("Completely closing connection '" + this + "'"));
                            }
                            this.destroy();
                        }
                        if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                            CachingConnectionFactory.this.logger.debug((Object)("Returning connection '" + this + "' to cache"));
                        }
                        CachingConnectionFactory.this.idleConnections.add(this);
                        if (CachingConnectionFactory.this.connectionHighWaterMark.get() < CachingConnectionFactory.this.idleConnections.size()) {
                            CachingConnectionFactory.this.connectionHighWaterMark.set(CachingConnectionFactory.this.idleConnections.size());
                        }
                        CachingConnectionFactory.this.connectionMonitor.notifyAll();
                    }
                }
            }
        }

        private int countOpenIdleConnections() {
            int n = 0;
            for (ChannelCachingConnectionProxy proxy : CachingConnectionFactory.this.idleConnections) {
                if (!proxy.isOpen()) continue;
                ++n;
            }
            return n;
        }

        public void destroy() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL) {
                CachingConnectionFactory.this.reset(CachingConnectionFactory.this.cachedChannelsNonTransactional, CachingConnectionFactory.this.cachedChannelsTransactional);
            } else {
                CachingConnectionFactory.this.reset((List)CachingConnectionFactory.this.allocatedConnectionNonTransactionalChannels.get(this), (List)CachingConnectionFactory.this.allocatedConnectionTransactionalChannels.get(this));
            }
            if (this.target != null) {
                RabbitUtils.closeConnection(this.target);
                this.notifyCloseIfNecessary();
            }
            this.target = null;
        }

        private void notifyCloseIfNecessary() {
            if (!this.closeNotified.getAndSet(true)) {
                CachingConnectionFactory.this.getConnectionListener().onClose(this);
            }
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public Connection getTargetConnection() {
            return this.target;
        }

        @Override
        public com.rabbitmq.client.Connection getDelegate() {
            return this.target.getDelegate();
        }

        @Override
        public int getLocalPort() {
            Connection target = this.target;
            if (target != null) {
                return target.getLocalPort();
            }
            return 0;
        }

        public String toString() {
            return "Proxy@" + ObjectUtils.getIdentityHexString((Object)this) + " " + (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL ? "Shared " : "Dedicated ") + "Rabbit Connection: " + this.target;
        }
    }

    private final class CachedChannelInvocationHandler
    implements InvocationHandler {
        private final ChannelCachingConnectionProxy theConnection;
        private final LinkedList<ChannelProxy> channelList;
        private final String channelListIdentity;
        private final Object targetMonitor = new Object();
        private final boolean transactional;
        private volatile Channel target;
        private volatile boolean txStarted;

        CachedChannelInvocationHandler(ChannelCachingConnectionProxy connection, Channel target, LinkedList<ChannelProxy> channelList, boolean transactional) {
            this.theConnection = connection;
            this.target = target;
            this.channelList = channelList;
            this.channelListIdentity = ObjectUtils.getIdentityHexString(channelList);
            this.transactional = transactional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (CachingConnectionFactory.this.logger.isTraceEnabled() && !method.getName().equals("toString") && !method.getName().equals("hashCode") && !method.getName().equals("equals")) {
                try {
                    CachingConnectionFactory.this.logger.trace((Object)(this.target + " channel." + method.getName() + "(" + (args != null ? Arrays.toString(args) : "") + ")"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((methodName = method.getName()).equals("txSelect") && !this.transactional) {
                throw new UnsupportedOperationException("Cannot start transaction on non-transactional channel");
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return "Cached Rabbit Channel: " + this.target + ", conn: " + this.theConnection;
            }
            if (methodName.equals("close")) {
                if (CachingConnectionFactory.this.active) {
                    LinkedList<ChannelProxy> linkedList = this.channelList;
                    synchronized (linkedList) {
                        if (!RabbitUtils.isPhysicalCloseRequired() && (this.channelList.size() < CachingConnectionFactory.this.getChannelCacheSize() || this.channelList.contains(proxy))) {
                            this.releasePermitIfNecessary(proxy);
                            this.logicalClose((ChannelProxy)proxy);
                            return null;
                        }
                    }
                }
                this.physicalClose();
                this.releasePermitIfNecessary(proxy);
                return null;
            }
            if (methodName.equals("getTargetChannel")) {
                return this.target;
            }
            if (methodName.equals("isOpen")) {
                return this.target != null && this.target.isOpen();
            }
            if (methodName.equals("isTransactional")) {
                return this.transactional;
            }
            try {
                if (this.target == null || !this.target.isOpen()) {
                    if (this.target instanceof PublisherCallbackChannel) {
                        this.target.close();
                        throw new InvocationTargetException(new AmqpException("PublisherCallbackChannel is closed"));
                    }
                    if (this.txStarted) {
                        this.txStarted = false;
                        throw new InvocationTargetException(new IllegalStateException("Channel closed during transaction"));
                    }
                    if (ackMethods.contains(methodName)) {
                        throw new InvocationTargetException(new IllegalStateException("Channel closed; cannot ack/nack"));
                    }
                    this.target = null;
                }
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target == null) {
                        this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                    }
                    Object result = method.invoke((Object)this.target, args);
                    if (this.transactional) {
                        if (txStarts.contains(methodName)) {
                            this.txStarted = true;
                        } else if (txEnds.contains(methodName)) {
                            this.txStarted = false;
                        }
                    }
                    return result;
                }
            }
            catch (InvocationTargetException ex) {
                if (this.target == null || !this.target.isOpen()) {
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Detected closed channel on exception.  Re-initializing: " + this.target));
                    }
                    this.target = null;
                    Object object = this.targetMonitor;
                    synchronized (object) {
                        if (this.target == null) {
                            this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                        }
                    }
                }
                throw ex.getTargetException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releasePermitIfNecessary(Object proxy) {
            if (CachingConnectionFactory.this.channelCheckoutTimeout > 0L) {
                LinkedList<ChannelProxy> linkedList = this.channelList;
                synchronized (linkedList) {
                    if (this.channelList.contains(proxy)) {
                        return;
                    }
                }
                Semaphore checkoutPermits = (Semaphore)CachingConnectionFactory.this.checkoutPermits.get(this.theConnection);
                if (checkoutPermits != null) {
                    checkoutPermits.release();
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Released permit for '" + this.theConnection + "', remaining: " + checkoutPermits.availablePermits()));
                    }
                } else {
                    CachingConnectionFactory.this.logger.error((Object)("LEAKAGE: No permits map entry for " + this.theConnection));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logicalClose(ChannelProxy proxy) throws Exception {
            if (this.target == null) {
                return;
            }
            if (this.target != null && !this.target.isOpen()) {
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target != null && !this.target.isOpen()) {
                        if (this.target instanceof PublisherCallbackChannel) {
                            this.target.close();
                        }
                        if (this.channelList.contains(proxy)) {
                            this.channelList.remove(proxy);
                        }
                        this.target = null;
                        return;
                    }
                }
            }
            if (!this.channelList.contains(proxy)) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Returning cached Channel: " + this.target));
                }
                this.channelList.addLast(proxy);
                this.setHighWaterMark();
            }
        }

        private void setHighWaterMark() {
            AtomicInteger hwm = (AtomicInteger)CachingConnectionFactory.this.channelHighWaterMarks.get(this.channelListIdentity);
            if (hwm != null) {
                int prev = hwm.get();
                int size = this.channelList.size();
                if (size > prev) {
                    hwm.set(size);
                }
            }
        }

        private void physicalClose() throws Exception {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Channel: " + this.target));
            }
            if (this.target == null) {
                return;
            }
            try {
                if (CachingConnectionFactory.this.active && (CachingConnectionFactory.this.publisherConfirms || CachingConnectionFactory.this.publisherReturns)) {
                    this.asyncClose();
                } else {
                    this.target.close();
                    if (this.target instanceof AutorecoveringChannel) {
                        ClosingRecoveryListener.removeChannel((AutorecoveringChannel)this.target);
                    }
                }
            }
            catch (AlreadyClosedException e) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)(this.target + " is already closed"));
                }
            }
            finally {
                this.target = null;
            }
        }

        private void asyncClose() {
            ExecutorService executorService = CachingConnectionFactory.this.getDeferredCloseExecutor();
            Channel channel = this.target;
            executorService.execute(() -> {
                try {
                    if (CachingConnectionFactory.this.publisherConfirms) {
                        channel.waitForConfirmsOrDie(5000L);
                    } else {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e6) {
                }
                finally {
                    block29: {
                        try {
                            channel.close();
                        }
                        catch (IOException e1) {
                        }
                        catch (AlreadyClosedException e1) {
                        }
                        catch (TimeoutException e1) {
                        }
                        catch (ShutdownSignalException e6) {
                            if (RabbitUtils.isNormalShutdown(e6)) break block29;
                            CachingConnectionFactory.this.logger.debug((Object)"Unexpected exception on deferred close", (Throwable)e6);
                        }
                    }
                }
            });
        }
    }

    public static enum CacheMode {
        CHANNEL,
        CONNECTION;

    }
}

