/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.QueueInfo;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LocalizedQueueConnectionFactory
implements ConnectionFactory,
RoutingConnectionFactory,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, ConnectionFactory> nodeFactories = new HashMap<String, ConnectionFactory>();
    private final ConnectionFactory defaultConnectionFactory;
    private final String[] adminUris;
    private final Map<String, String> nodeToAddress = new HashMap<String, String>();
    private final String vhost;
    private final String username;
    private final String password;
    private final boolean useSSL;
    private final Resource sslPropertiesLocation;
    private final String keyStore;
    private final String trustStore;
    private final String keyStorePassPhrase;
    private final String trustStorePassPhrase;

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, Map<String, String> nodeToAddress, String[] adminUris, String vhost, String username, String password, boolean useSSL, Resource sslPropertiesLocation) {
        Assert.notNull((Object)defaultConnectionFactory, (String)"'defaultConnectionFactory' cannot be null");
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.adminUris = Arrays.copyOf(adminUris, adminUris.length);
        this.nodeToAddress.putAll(nodeToAddress);
        this.vhost = vhost;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.sslPropertiesLocation = sslPropertiesLocation;
        this.keyStore = null;
        this.trustStore = null;
        this.keyStorePassPhrase = null;
        this.trustStorePassPhrase = null;
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, Map<String, String> nodeToAddress, String[] adminUris, String vhost, String username, String password, boolean useSSL, String keyStore, String trustStore, String keyStorePassPhrase, String trustStorePassPhrase) {
        Assert.notNull((Object)defaultConnectionFactory, (String)"'defaultConnectionFactory' cannot be null");
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.adminUris = Arrays.copyOf(adminUris, adminUris.length);
        this.nodeToAddress.putAll(nodeToAddress);
        this.vhost = vhost;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.sslPropertiesLocation = null;
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassPhrase = keyStorePassPhrase;
        this.trustStorePassPhrase = trustStorePassPhrase;
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, String[] addresses, String[] adminUris, String[] nodes, String vhost, String username, String password, boolean useSSL, Resource sslPropertiesLocation) {
        Assert.notNull((Object)defaultConnectionFactory, (String)"'defaultConnectionFactory' cannot be null");
        Assert.isTrue((addresses.length == nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.adminUris = Arrays.copyOf(adminUris, adminUris.length);
        for (int i = 0; i < addresses.length; ++i) {
            this.nodeToAddress.put(nodes[i], addresses[i]);
        }
        this.vhost = vhost;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.sslPropertiesLocation = sslPropertiesLocation;
        this.keyStore = null;
        this.trustStore = null;
        this.keyStorePassPhrase = null;
        this.trustStorePassPhrase = null;
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, String[] addresses, String[] adminUris, String[] nodes, String vhost, String username, String password, boolean useSSL, String keyStore, String trustStore, String keyStorePassPhrase, String trustStorePassPhrase) {
        Assert.notNull((Object)defaultConnectionFactory, (String)"'defaultConnectionFactory' cannot be null");
        Assert.isTrue((addresses.length == nodes.length ? 1 : 0) != 0, (String)"'addresses', 'adminAddresses', and 'nodes' properties must have equal length");
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.adminUris = Arrays.copyOf(adminUris, adminUris.length);
        for (int i = 0; i < addresses.length; ++i) {
            this.nodeToAddress.put(nodes[i], addresses[i]);
        }
        this.vhost = vhost;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.sslPropertiesLocation = null;
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassPhrase = keyStorePassPhrase;
        this.trustStorePassPhrase = trustStorePassPhrase;
    }

    @Override
    public Connection createConnection() throws AmqpException {
        return this.defaultConnectionFactory.createConnection();
    }

    @Override
    public String getHost() {
        return this.defaultConnectionFactory.getHost();
    }

    @Override
    public int getPort() {
        return this.defaultConnectionFactory.getPort();
    }

    @Override
    public String getVirtualHost() {
        return this.vhost;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.defaultConnectionFactory.addConnectionListener(listener);
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.defaultConnectionFactory.removeConnectionListener(listener);
    }

    @Override
    public void clearConnectionListeners() {
        this.defaultConnectionFactory.clearConnectionListeners();
    }

    @Override
    public ConnectionFactory getTargetConnectionFactory(Object key) {
        String queue = (String)key;
        Assert.isTrue((!(queue = queue.substring(1, queue.length() - 1)).contains(",") ? 1 : 0) != 0, () -> "Cannot use LocalizedQueueConnectionFactory with more than one queue: " + key);
        ConnectionFactory connectionFactory = this.determineConnectionFactory(queue);
        if (connectionFactory == null) {
            return this.defaultConnectionFactory;
        }
        return connectionFactory;
    }

    private ConnectionFactory determineConnectionFactory(String queue) {
        for (int i = 0; i < this.adminUris.length; ++i) {
            String adminUri = this.adminUris[i];
            if (!adminUri.endsWith("/api/")) {
                adminUri = adminUri + "/api/";
            }
            try {
                Client client = this.createClient(adminUri, this.username, this.password);
                QueueInfo queueInfo = client.getQueue(this.vhost, queue);
                if (queueInfo != null) {
                    String node = queueInfo.getNode();
                    if (node == null) continue;
                    String uri = this.nodeToAddress.get(node);
                    if (uri != null) {
                        return this.nodeConnectionFactory(queue, node, uri);
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("No match for node: " + node));
                    continue;
                }
                throw new AmqpException("Admin returned null QueueInfo");
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to determine queue location for: " + queue + " at: " + adminUri + ": " + e.getMessage()));
            }
        }
        this.logger.warn((Object)("Failed to determine queue location for: " + queue + ", using default connection factory"));
        return null;
    }

    protected Client createClient(String adminUri, String username, String password) throws MalformedURLException, URISyntaxException {
        return new Client(adminUri, username, password);
    }

    private synchronized ConnectionFactory nodeConnectionFactory(String queue, String node, String address) throws Exception {
        ConnectionFactory cf;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Queue: " + queue + " is on node: " + node + " at: " + address));
        }
        if ((cf = this.nodeFactories.get(node)) == null) {
            cf = this.createConnectionFactory(address, node);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Created new connection factory: " + cf));
            }
            this.nodeFactories.put(node, cf);
        }
        return cf;
    }

    protected ConnectionFactory createConnectionFactory(String address, String node) throws Exception {
        RabbitConnectionFactoryBean rcfb = new RabbitConnectionFactoryBean();
        rcfb.setUseSSL(this.useSSL);
        rcfb.setSslPropertiesLocation(this.sslPropertiesLocation);
        rcfb.setKeyStore(this.keyStore);
        rcfb.setTrustStore(this.trustStore);
        rcfb.setKeyStorePassphrase(this.keyStorePassPhrase);
        rcfb.setTrustStorePassphrase(this.trustStorePassPhrase);
        rcfb.afterPropertiesSet();
        CachingConnectionFactory ccf = new CachingConnectionFactory((com.rabbitmq.client.ConnectionFactory)rcfb.getObject());
        ccf.setAddresses(address);
        ccf.setUsername(this.username);
        ccf.setPassword(this.password);
        ccf.setVirtualHost(this.vhost);
        ccf.setBeanName("node:" + node);
        return ccf;
    }

    public void destroy() throws Exception {
        for (ConnectionFactory connectionFactory : this.nodeFactories.values()) {
            if (!(connectionFactory instanceof DisposableBean)) continue;
            ((DisposableBean)connectionFactory).destroy();
        }
        if (this.defaultConnectionFactory instanceof DisposableBean) {
            ((DisposableBean)this.defaultConnectionFactory).destroy();
        }
    }
}

