/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;

public class MultiRabbitListenerAnnotationBeanPostProcessor
extends RabbitListenerAnnotationBeanPostProcessor {
    public static final String CONNECTION_FACTORY_BEAN_NAME = "multiRabbitConnectionFactory";
    public static final String CONNECTION_FACTORY_CREATOR_BEAN_NAME = "rabbitConnectionFactoryCreator";
    private static final String DEFAULT_RABBIT_ADMIN_BEAN_NAME = "defaultRabbitAdmin";
    private static final String RABBIT_ADMIN_SUFFIX = "-admin";

    @Override
    protected Collection<Declarable> processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        Collection<Declarable> declarables = super.processAmqpListener(rabbitListener, method, bean, beanName);
        String rabbitAdmin = this.resolveMultiRabbitAdminName(rabbitListener);
        for (Declarable declarable : declarables) {
            if (!declarable.getDeclaringAdmins().isEmpty()) continue;
            declarable.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin});
        }
        return declarables;
    }

    protected String resolveMultiRabbitAdminName(RabbitListener rabbitListener) {
        String admin = super.resolveExpressionAsString(rabbitListener.admin(), "admin");
        if (!StringUtils.hasText((String)admin) && StringUtils.hasText((String)rabbitListener.containerFactory())) {
            admin = rabbitListener.containerFactory() + RABBIT_ADMIN_SUFFIX;
        }
        if (!StringUtils.hasText((String)admin)) {
            admin = DEFAULT_RABBIT_ADMIN_BEAN_NAME;
        }
        return admin;
    }
}

