/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.springframework.amqp.core.Correlation;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CorrelationData
implements Correlation {
    private final CompletableFuture<Confirm> future = new CompletableFuture();
    private volatile String id;
    private volatile ReturnedMessage returnedMessage;

    public CorrelationData() {
        this.id = UUID.randomUUID().toString();
    }

    public CorrelationData(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public CompletableFuture<Confirm> getFuture() {
        return this.future;
    }

    @Nullable
    public ReturnedMessage getReturned() {
        return this.returnedMessage;
    }

    public void setReturned(ReturnedMessage returned) {
        this.returnedMessage = returned;
    }

    public String toString() {
        return "CorrelationData [id=" + this.id + "]";
    }

    public static class Confirm {
        private final boolean ack;
        private final String reason;

        public Confirm(boolean ack, @Nullable String reason) {
            this.ack = ack;
            this.reason = reason;
        }

        public boolean isAck() {
            return this.ack;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "Confirm [ack=" + this.ack + (String)(this.reason != null ? ", reason=" + this.reason : "") + "]";
        }
    }
}

