/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatefulRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.interceptor.StatefulRetryOperationsInterceptor;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class RetryInterceptorBuilder<B extends RetryInterceptorBuilder<B, T>, T extends MethodInterceptor> {
    private @Nullable RetryOperations retryOperations;
    private final RetryTemplate retryTemplate = new RetryTemplate();
    private final SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy();
    private @Nullable MessageRecoverer messageRecoverer;
    private boolean templateAltered;
    private boolean backOffPolicySet;
    private boolean retryPolicySet;
    private boolean backOffOptionsSet;

    public static StatefulRetryInterceptorBuilder stateful() {
        return new StatefulRetryInterceptorBuilder();
    }

    public static StatelessRetryInterceptorBuilder stateless() {
        return new StatelessRetryInterceptorBuilder();
    }

    protected final B _this() {
        return (B)this;
    }

    public B retryOperations(RetryOperations retryOperations) {
        Assert.isTrue((!this.templateAltered ? 1 : 0) != 0, (String)"Cannot set retryOperations when the default has been modified");
        this.retryOperations = retryOperations;
        return this._this();
    }

    public B maxAttempts(int maxAttempts) {
        Assert.isNull((Object)this.retryOperations, (String)"cannot alter the retry policy when a custom retryOperations has been set");
        Assert.isTrue((!this.retryPolicySet ? 1 : 0) != 0, (String)"cannot alter the retry policy when a custom retryPolicy has been set");
        this.simpleRetryPolicy.setMaxAttempts(maxAttempts);
        this.retryTemplate.setRetryPolicy((RetryPolicy)this.simpleRetryPolicy);
        this.templateAltered = true;
        return this._this();
    }

    public B backOffOptions(long initialInterval, double multiplier, long maxInterval) {
        Assert.isNull((Object)this.retryOperations, (String)"cannot set the back off policy when a custom retryOperations has been set");
        Assert.isTrue((!this.backOffPolicySet ? 1 : 0) != 0, (String)"cannot set the back off options when a back off policy has been set");
        ExponentialBackOffPolicy policy = new ExponentialBackOffPolicy();
        policy.setInitialInterval(initialInterval);
        policy.setMultiplier(multiplier);
        policy.setMaxInterval(maxInterval);
        this.retryTemplate.setBackOffPolicy((BackOffPolicy)policy);
        this.backOffOptionsSet = true;
        this.templateAltered = true;
        return this._this();
    }

    public B retryPolicy(RetryPolicy policy) {
        Assert.isNull((Object)this.retryOperations, (String)"cannot set the retry policy when a custom retryOperations has been set");
        Assert.isTrue((!this.templateAltered ? 1 : 0) != 0, (String)"cannot set the retry policy if max attempts or back off policy or options changed");
        this.retryTemplate.setRetryPolicy(policy);
        this.retryPolicySet = true;
        this.templateAltered = true;
        return this._this();
    }

    public B backOffPolicy(BackOffPolicy policy) {
        Assert.isNull((Object)this.retryOperations, (String)"cannot set the back off policy when a custom retryOperations has been set");
        Assert.isTrue((!this.backOffOptionsSet ? 1 : 0) != 0, (String)"cannot set the back off policy when the back off policy options have been set");
        this.retryTemplate.setBackOffPolicy(policy);
        this.templateAltered = true;
        this.backOffPolicySet = true;
        return this._this();
    }

    public B recoverer(MessageRecoverer recoverer) {
        this.messageRecoverer = recoverer;
        return this._this();
    }

    protected void applyCommonSettings(AbstractRetryOperationsInterceptorFactoryBean factoryBean) {
        if (this.messageRecoverer != null) {
            factoryBean.setMessageRecoverer(this.messageRecoverer);
        }
        factoryBean.setRetryOperations((RetryOperations)Objects.requireNonNullElse(this.retryOperations, this.retryTemplate));
    }

    public abstract T build();

    public static final class StatefulRetryInterceptorBuilder
    extends RetryInterceptorBuilder<StatefulRetryInterceptorBuilder, StatefulRetryOperationsInterceptor> {
        private final StatefulRetryOperationsInterceptorFactoryBean factoryBean = new StatefulRetryOperationsInterceptorFactoryBean();
        private @Nullable MessageKeyGenerator messageKeyGenerator;
        private @Nullable NewMessageIdentifier newMessageIdentifier;

        StatefulRetryInterceptorBuilder() {
        }

        public StatefulRetryInterceptorBuilder messageKeyGenerator(MessageKeyGenerator messageKeyGenerator) {
            this.messageKeyGenerator = messageKeyGenerator;
            return this;
        }

        public StatefulRetryInterceptorBuilder newMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
            this.newMessageIdentifier = newMessageIdentifier;
            return this;
        }

        @Override
        public StatefulRetryOperationsInterceptor build() {
            this.applyCommonSettings(this.factoryBean);
            if (this.messageKeyGenerator != null) {
                this.factoryBean.setMessageKeyGenerator(this.messageKeyGenerator);
            }
            if (this.newMessageIdentifier != null) {
                this.factoryBean.setNewMessageIdentifier(this.newMessageIdentifier);
            }
            return this.factoryBean.getObject();
        }
    }

    public static final class StatelessRetryInterceptorBuilder
    extends RetryInterceptorBuilder<StatelessRetryInterceptorBuilder, RetryOperationsInterceptor> {
        private final StatelessRetryOperationsInterceptorFactoryBean factoryBean = new StatelessRetryOperationsInterceptorFactoryBean();

        StatelessRetryInterceptorBuilder() {
        }

        @Override
        public RetryOperationsInterceptor build() {
            this.applyCommonSettings(this.factoryBean);
            return this.factoryBean.getObject();
        }
    }
}

