/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;

public final class ConsumerChannelRegistry {
    private static final Log logger = LogFactory.getLog(ConsumerChannelRegistry.class);
    private static final ThreadLocal<@Nullable ChannelHolder> CONSUMER_CHANNEL = new ThreadLocal();

    private ConsumerChannelRegistry() {
    }

    public static void registerConsumerChannel(Channel channel, ConnectionFactory connectionFactory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering consumer channel" + String.valueOf(channel) + " from factory " + String.valueOf(connectionFactory)));
        }
        CONSUMER_CHANNEL.set(new ChannelHolder(channel, connectionFactory));
    }

    public static void unRegisterConsumerChannel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unregistering consumer channel" + String.valueOf(CONSUMER_CHANNEL.get())));
        }
        CONSUMER_CHANNEL.remove();
    }

    public static @Nullable Channel getConsumerChannel() {
        ChannelHolder channelHolder = CONSUMER_CHANNEL.get();
        return channelHolder != null ? channelHolder.channel() : null;
    }

    public static @Nullable Channel getConsumerChannel(ConnectionFactory connectionFactory) {
        ChannelHolder channelHolder = CONSUMER_CHANNEL.get();
        Channel channel = null;
        if (channelHolder != null && channelHolder.connectionFactory().equals(connectionFactory)) {
            channel = channelHolder.channel();
        }
        return channel;
    }

    private record ChannelHolder(Channel channel, ConnectionFactory connectionFactory) {
    }
}

