/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodRabbitListenerEndpoint
extends AbstractRabbitListenerEndpoint {
    private Object bean;
    private @Nullable Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private boolean returnExceptions;
    private @Nullable RabbitListenerErrorHandler errorHandler;
    private AdapterProvider adapterProvider = new DefaultAdapterProvider();

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public @Nullable Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setReturnExceptions(boolean returnExceptions) {
        this.returnExceptions = returnExceptions;
    }

    public void setErrorHandler(RabbitListenerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected @Nullable MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setAdapterProvider(AdapterProvider adapterProvider) {
        Assert.notNull((Object)adapterProvider, (String)"'adapterProvider' cannot be null");
        this.adapterProvider = adapterProvider;
    }

    @Override
    protected MessagingMessageListenerAdapter createMessageListener(MessageListenerContainer container) {
        MessageConverter messageConverter;
        MessagingMessageListenerAdapter messageListener = this.createMessageListenerInstance(this.getBatchListener());
        messageListener.setHandlerAdapter(this.configureListenerAdapter(messageListener));
        String replyToAddress = this.getDefaultReplyToAddress();
        if (replyToAddress != null) {
            messageListener.setResponseAddress(replyToAddress);
        }
        if ((messageConverter = this.getMessageConverter()) != null) {
            messageListener.setMessageConverter(messageConverter);
        }
        messageListener.setBeanResolver(this.getBeanResolver());
        return messageListener;
    }

    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter messageListener) {
        Method methodToUse = this.getMethod();
        Assert.notNull((Object)methodToUse, (String)"'method' must be provided");
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), methodToUse);
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected MessagingMessageListenerAdapter createMessageListenerInstance(@Nullable Boolean batch) {
        return this.adapterProvider.getAdapter(batch == null ? this.isBatchListener() : batch.booleanValue(), this.bean, this.method, this.returnExceptions, this.errorHandler, this.getBatchingStrategy());
    }

    private @Nullable String getDefaultReplyToAddress() {
        SendTo ann;
        Method listenerMethod = this.getMethod();
        if (listenerMethod != null && (ann = (SendTo)AnnotationUtils.getAnnotation((Method)listenerMethod, SendTo.class)) != null) {
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + String.valueOf(listenerMethod) + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            return destinations.length == 1 ? this.resolveSendTo((String)destinations[0]) : "";
        }
        return null;
    }

    private @Nullable String resolveSendTo(String value) {
        BeanExpressionContext beanExpressionContext = this.getBeanExpressionContext();
        if (beanExpressionContext != null) {
            String resolvedValue = beanExpressionContext.getBeanFactory().resolveEmbeddedValue(value);
            BeanExpressionResolver resolverToUse = this.getResolver();
            if (resolverToUse != null) {
                Object newValue = resolverToUse.evaluate(resolvedValue, beanExpressionContext);
                Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
                return (String)newValue;
            }
        }
        return value;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }

    private static final class DefaultAdapterProvider
    implements AdapterProvider {
        private DefaultAdapterProvider() {
        }

        @Override
        public MessagingMessageListenerAdapter getAdapter(boolean batch, @Nullable Object bean, @Nullable Method method, boolean returnExceptions, @Nullable RabbitListenerErrorHandler errorHandler, @Nullable BatchingStrategy batchingStrategy) {
            if (batch) {
                return new BatchMessagingMessageListenerAdapter(bean, method, returnExceptions, errorHandler, batchingStrategy);
            }
            return new MessagingMessageListenerAdapter(bean, method, returnExceptions, errorHandler);
        }
    }

    public static interface AdapterProvider {
        public MessagingMessageListenerAdapter getAdapter(boolean var1, @Nullable Object var2, @Nullable Method var3, boolean var4, @Nullable RabbitListenerErrorHandler var5, @Nullable BatchingStrategy var6);
    }
}

