/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelListener;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class PooledChannelConnectionFactory
extends AbstractConnectionFactory
implements ShutdownListener,
SmartLifecycle {
    private final AtomicBoolean running = new AtomicBoolean();
    private final Lock lock = new ReentrantLock();
    private volatile @Nullable ConnectionWrapper connection;
    private boolean simplePublisherConfirms;
    private BiConsumer<GenericObjectPool<Channel>, Boolean> poolConfigurer = (pool, tx) -> {};
    private boolean defaultPublisherFactory = true;

    public PooledChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private PooledChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory, boolean isPublisher) {
        super(rabbitConnectionFactory);
        if (!isPublisher) {
            this.doSetPublisherConnectionFactory(new PooledChannelConnectionFactory(rabbitConnectionFactory, true));
        } else {
            this.defaultPublisherFactory = false;
        }
    }

    @Override
    public void setPublisherConnectionFactory(@Nullable AbstractConnectionFactory publisherConnectionFactory) {
        super.setPublisherConnectionFactory(publisherConnectionFactory);
        this.defaultPublisherFactory = false;
    }

    public void setPoolConfigurer(BiConsumer<GenericObjectPool<Channel>, Boolean> poolConfigurer) {
        Assert.notNull(poolConfigurer, (String)"'poolConfigurer' cannot be null");
        this.poolConfigurer = poolConfigurer;
        if (this.defaultPublisherFactory) {
            ((PooledChannelConnectionFactory)this.getPublisherConnectionFactory()).setPoolConfigurer(poolConfigurer);
        }
    }

    @Override
    public boolean isSimplePublisherConfirms() {
        return this.simplePublisherConfirms;
    }

    public void setSimplePublisherConfirms(boolean simplePublisherConfirms) {
        this.simplePublisherConfirms = simplePublisherConfirms;
        if (this.defaultPublisherFactory) {
            ((PooledChannelConnectionFactory)this.getPublisherConnectionFactory()).setSimplePublisherConfirms(simplePublisherConfirms);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        ConnectionWrapper connectionWrapper = this.connection;
        if (connectionWrapper != null && connectionWrapper.isOpen()) {
            listener.onCreate(connectionWrapper);
        }
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        this.running.set(false);
        this.resetConnection();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public Connection createConnection() throws AmqpException {
        ConnectionWrapper connectionWrapper = this.connection;
        if (connectionWrapper == null || !connectionWrapper.isOpen()) {
            this.lock.lock();
            try {
                connectionWrapper = this.connection;
                if (connectionWrapper == null || !connectionWrapper.isOpen()) {
                    Connection bareConnection = this.createBareConnection();
                    this.connection = connectionWrapper = new ConnectionWrapper(bareConnection.getDelegate(), this.getCloseTimeout(), this.simplePublisherConfirms, this.poolConfigurer, this.getChannelListener());
                    this.getConnectionListener().onCreate(this.connection);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return connectionWrapper;
    }

    @Override
    public void resetConnection() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.lock.lock();
        try {
            super.destroy();
            ConnectionWrapper connectionWrapper = this.connection;
            if (connectionWrapper != null) {
                connectionWrapper.forceClose();
                this.getConnectionListener().onClose(connectionWrapper);
                this.connection = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class ConnectionWrapper
    extends SimpleConnection {
        private static final Log LOGGER = LogFactory.getLog(ConnectionWrapper.class);
        private final ObjectPool<Channel> channels;
        private final ObjectPool<Channel> txChannels;
        private final boolean simplePublisherConfirms;
        private final ChannelListener channelListener;

        ConnectionWrapper(com.rabbitmq.client.Connection delegate, int closeTimeout, boolean simplePublisherConfirms, BiConsumer<GenericObjectPool<Channel>, Boolean> configurer, ChannelListener channelListener) {
            super(delegate, closeTimeout);
            this.channels = this.createPool(new ChannelFactory(), configurer, false);
            this.txChannels = this.createPool(new TxChannelFactory(), configurer, true);
            this.simplePublisherConfirms = simplePublisherConfirms;
            this.channelListener = channelListener;
        }

        private GenericObjectPool<Channel> createPool(ChannelFactory channelFactory, BiConsumer<GenericObjectPool<Channel>, Boolean> configurer, boolean tx) {
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)channelFactory);
            configurer.accept((GenericObjectPool<Channel>)pool, tx);
            return pool;
        }

        @Override
        public Channel createChannel(boolean transactional) {
            try {
                Channel channel = transactional ? (Channel)this.txChannels.borrowObject() : (Channel)this.channels.borrowObject();
                this.channelListener.onCreate(channel, transactional);
                return channel;
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
        }

        private Channel createProxy(Channel channel, boolean transacted) {
            ProxyFactory pf = new ProxyFactory((Object)channel);
            AtomicReference<Channel> proxy = new AtomicReference<Channel>();
            AtomicBoolean confirmSelected = new AtomicBoolean();
            MethodInterceptor advice = invocation -> {
                String method;
                return switch (method = invocation.getMethod().getName()) {
                    case "close" -> {
                        this.handleClose(channel, transacted, proxy);
                        yield null;
                    }
                    case "getTargetChannel" -> channel;
                    case "isTransactional" -> Boolean.valueOf(transacted);
                    case "confirmSelect" -> {
                        confirmSelected.set(true);
                        yield channel.confirmSelect();
                    }
                    case "isConfirmSelected" -> Boolean.valueOf(confirmSelected.get());
                    case "isPublisherConfirms" -> Boolean.valueOf(false);
                    default -> null;
                };
            };
            NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
            advisor.addMethodName("close");
            advisor.addMethodName("getTargetChannel");
            advisor.addMethodName("isTransactional");
            advisor.addMethodName("confirmSelect");
            advisor.addMethodName("isConfirmSelected");
            advisor.addMethodName("isPublisherConfirms");
            pf.addAdvisor((Advisor)advisor);
            pf.addInterface(ChannelProxy.class);
            proxy.set((Channel)pf.getProxy());
            return (Channel)proxy.get();
        }

        private void handleClose(Channel channel, boolean transacted, AtomicReference<Channel> proxy) throws Exception {
            if (!RabbitUtils.isPhysicalCloseRequired()) {
                if (transacted) {
                    this.txChannels.returnObject((Object)proxy.get());
                } else {
                    this.channels.returnObject((Object)proxy.get());
                }
            } else {
                this.physicalClose(channel);
            }
        }

        @Override
        public void close() {
        }

        void forceClose() {
            super.close();
            this.channels.close();
            this.txChannels.close();
        }

        private void physicalClose(Channel channel) {
            RabbitUtils.clearPhysicalCloseRequired();
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    LOGGER.debug((Object)"Error on close", (Throwable)e);
                }
            }
        }

        private class ChannelFactory
        implements PooledObjectFactory<Channel> {
            private ChannelFactory() {
            }

            public PooledObject<Channel> makeObject() {
                Channel channel = ConnectionWrapper.this.createProxy(ConnectionWrapper.super.createChannel(false), false);
                if (ConnectionWrapper.this.simplePublisherConfirms) {
                    try {
                        channel.confirmSelect();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                }
                return new DefaultPooledObject((Object)channel);
            }

            public void destroyObject(PooledObject<Channel> p) throws Exception {
                Channel channel = (Channel)p.getObject();
                if (channel instanceof ChannelProxy) {
                    ChannelProxy channelProxy = (ChannelProxy)channel;
                    channel = channelProxy.getTargetChannel();
                }
                ConnectionWrapper.this.physicalClose(channel);
            }

            public boolean validateObject(PooledObject<Channel> p) {
                return ((Channel)p.getObject()).isOpen();
            }

            public void activateObject(PooledObject<Channel> p) {
            }

            public void passivateObject(PooledObject<Channel> p) {
            }
        }

        private final class TxChannelFactory
        extends ChannelFactory {
            private TxChannelFactory() {
            }

            @Override
            public PooledObject<Channel> makeObject() {
                Channel channel = ConnectionWrapper.this.createProxy(ConnectionWrapper.super.createChannel(true), true);
                try {
                    channel.txSelect();
                }
                catch (IOException e) {
                    throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                }
                return new DefaultPooledObject((Object)channel);
            }
        }
    }
}

