/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.redis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.analytics.metrics.FieldValueCounter;
import org.springframework.analytics.metrics.FieldValueCounterRepository;
import org.springframework.analytics.retry.StringRedisRetryTemplate;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;

public class RedisFieldValueCounterRepository
implements FieldValueCounterRepository {
    private final String metricPrefix;
    private final StringRedisRetryTemplate redisTemplate;

    public RedisFieldValueCounterRepository(RedisConnectionFactory connectionFactory, RetryOperations retryOperations) {
        this(connectionFactory, "fieldvaluecounters.", retryOperations);
    }

    public RedisFieldValueCounterRepository(RedisConnectionFactory connectionFactory, String metricPrefix, RetryOperations retryOperations) {
        Assert.notNull((Object)connectionFactory);
        Assert.hasText((String)metricPrefix, (String)"metric prefix cannot be empty");
        this.metricPrefix = metricPrefix;
        this.redisTemplate = new StringRedisRetryTemplate(connectionFactory, retryOperations);
        this.redisTemplate.setExposeConnection(true);
        this.redisTemplate.afterPropertiesSet();
    }

    @Override
    public FieldValueCounter findOne(String name) {
        Assert.notNull((Object)name, (String)"The name of the FieldValueCounter must not be null");
        String metricKey = this.getMetricKey(name);
        if (this.redisTemplate.hasKey(metricKey).booleanValue()) {
            Map<String, Double> values = this.getZSetData(metricKey);
            FieldValueCounter c = new FieldValueCounter(name, values);
            return c;
        }
        return null;
    }

    @Override
    public Collection<String> list() {
        Set keys = this.redisTemplate.keys(this.getMetricKey("*"));
        HashSet<String> names = new HashSet<String>(keys.size());
        for (String key : keys) {
            names.add(this.getCounterName(key));
        }
        return names;
    }

    @Override
    public void increment(String counterName, String fieldName, double score) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, score);
    }

    @Override
    public void decrement(String counterName, String fieldName, double score) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, -score);
    }

    @Override
    public void reset(String counterName) {
        this.redisTemplate.delete(this.getMetricKey(counterName));
    }

    protected String getMetricKey(String metricName) {
        return this.metricPrefix + metricName;
    }

    private String getCounterName(String redisKey) {
        return redisKey.substring(this.metricPrefix.length());
    }

    protected Map<String, Double> getZSetData(String counterKey) {
        Set rangeWithScore = this.redisTemplate.boundZSetOps(counterKey).rangeWithScores(0L, -1L);
        HashMap<String, Double> values = new HashMap<String, Double>(rangeWithScore.size());
        for (ZSetOperations.TypedTuple typedTuple : rangeWithScore) {
            values.put((String)typedTuple.getValue(), typedTuple.getScore());
        }
        return values;
    }
}

