/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Months;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.springframework.analytics.metrics.AggregateCounter;
import org.springframework.analytics.metrics.AggregateCounterResolution;
import org.springframework.analytics.metrics.MetricUtils;
import org.springframework.util.Assert;

class InMemoryAggregateCounter {
    private final String name;
    private long value;
    private Map<Integer, long[]> monthCountsByYear = new HashMap<Integer, long[]>();
    private Map<Integer, long[]> dayCountsByYear = new HashMap<Integer, long[]>();
    private Map<Integer, long[]> hourCountsByDay = new HashMap<Integer, long[]>();
    private Map<Integer, long[]> minuteCountsByDay = new HashMap<Integer, long[]>();

    public InMemoryAggregateCounter(String name, long value) {
        this.name = name;
        this.value = value;
    }

    public InMemoryAggregateCounter(String name) {
        this.name = name;
        this.value = 0L;
    }

    public AggregateCounter getCounts(int nCounts, DateTime endDate, AggregateCounterResolution resolution) {
        Assert.notNull((Object)endDate, (String)"endDate must not be null");
        return this.getCounts(new Interval((ReadableInstant)resolution.minus(endDate, nCounts - 1), (ReadableInstant)endDate), resolution);
    }

    public AggregateCounter getCounts(Interval interval, AggregateCounterResolution resolution) {
        long[] counts;
        DateTime start = interval.getStart();
        DateTime end = interval.getEnd();
        Chronology c = interval.getChronology();
        if (resolution == AggregateCounterResolution.minute) {
            List<long[]> days = InMemoryAggregateCounter.accumulateDayCounts(this.minuteCountsByDay, start, end, 1440);
            counts = MetricUtils.concatArrays(days, interval.getStart().getMinuteOfDay(), interval.toPeriod().toStandardMinutes().getMinutes() + 1);
        } else if (resolution == AggregateCounterResolution.hour) {
            List<long[]> days = InMemoryAggregateCounter.accumulateDayCounts(this.hourCountsByDay, start, end, 24);
            counts = MetricUtils.concatArrays(days, interval.getStart().getHourOfDay(), interval.toPeriod().toStandardHours().getHours() + 1);
        } else if (resolution == AggregateCounterResolution.day) {
            DateTime startDay = new DateTime(c.dayOfYear().roundFloor(start.getMillis()));
            DateTime endDay = new DateTime(c.dayOfYear().roundFloor(end.plusDays(1).getMillis()));
            int nDays = Days.daysBetween((ReadableInstant)startDay, (ReadableInstant)endDay).getDays();
            DateTime cursor = new DateTime(c.year().roundFloor(interval.getStartMillis()));
            ArrayList<long[]> yearDays = new ArrayList<long[]>();
            DateTime endYear = new DateTime(c.year().roundCeiling(end.getMillis()));
            while (cursor.isBefore((ReadableInstant)endYear)) {
                long[] dayCounts = this.dayCountsByYear.get(cursor.getYear());
                if (dayCounts == null) {
                    dayCounts = new long[this.daysInYear(cursor.getYear())];
                }
                yearDays.add(dayCounts);
                cursor = cursor.plusYears(1);
            }
            counts = MetricUtils.concatArrays(yearDays, startDay.getDayOfYear() - 1, nDays);
        } else if (resolution == AggregateCounterResolution.month) {
            DateTime startMonth = new DateTime(c.monthOfYear().roundFloor(interval.getStartMillis()));
            DateTime endMonth = new DateTime(c.monthOfYear().roundFloor(end.plusMonths(1).getMillis()));
            int nMonths = Months.monthsBetween((ReadableInstant)startMonth, (ReadableInstant)endMonth).getMonths();
            DateTime cursor = new DateTime(c.year().roundFloor(interval.getStartMillis()));
            ArrayList<long[]> yearMonths = new ArrayList<long[]>();
            DateTime endYear = new DateTime(c.year().roundCeiling(end.getMillis()));
            while (cursor.isBefore((ReadableInstant)endYear)) {
                long[] monthCounts = this.monthCountsByYear.get(cursor.getYear());
                if (monthCounts == null) {
                    monthCounts = new long[12];
                }
                yearMonths.add(monthCounts);
                cursor = cursor.plusYears(1);
            }
            counts = MetricUtils.concatArrays(yearMonths, startMonth.getMonthOfYear() - 1, nMonths);
        } else if (resolution == AggregateCounterResolution.year) {
            DateTime startYear = new DateTime(interval.getStart().getYear(), 1, 1, 0, 0);
            DateTime endYear = new DateTime(end.getYear() + 1, 1, 1, 0, 0);
            int nYears = Years.yearsBetween((ReadableInstant)startYear, (ReadableInstant)endYear).getYears();
            counts = new long[nYears];
            for (int i = 0; i < nYears; ++i) {
                long[] monthCounts = this.monthCountsByYear.get(startYear.plusYears(i).getYear());
                counts[i] = MetricUtils.sum(monthCounts);
            }
        } else {
            throw new IllegalStateException("Shouldn't happen. Unhandled resolution: " + (Object)((Object)resolution));
        }
        return new AggregateCounter(this.name, interval, counts, resolution);
    }

    private static List<long[]> accumulateDayCounts(Map<Integer, long[]> fromDayCounts, DateTime start, DateTime end, int subSize) {
        ArrayList<long[]> days = new ArrayList<long[]>();
        Duration step = Duration.standardDays((long)1L);
        long[] emptySubArray = new long[subSize];
        end = end.plusDays(1);
        DateTime now = start;
        while (now.isBefore((ReadableInstant)end)) {
            int countsByDayKey = now.getYear() * 1000 + now.getDayOfYear();
            long[] dayCounts = fromDayCounts.get(countsByDayKey);
            if (dayCounts == null) {
                dayCounts = emptySubArray;
            }
            days.add(dayCounts);
            now = now.plus((ReadableDuration)step);
        }
        return days;
    }

    private int daysInYear(int year) {
        Duration d = new Duration((ReadableInstant)new DateTime(year, 1, 1, 0, 0), (ReadableInstant)new DateTime(year + 1, 1, 1, 0, 0));
        return (int)d.getStandardDays();
    }

    synchronized long increment(long amount) {
        return this.value += amount;
    }

    synchronized long increment(long amount, DateTime dateTime) {
        long[] minuteCounts;
        int countsByDayKey;
        long[] hourCounts;
        int year = dateTime.getYear();
        int month = dateTime.getMonthOfYear();
        int day = dateTime.getDayOfYear();
        int hour = dateTime.getHourOfDay();
        int minute = dateTime.getMinuteOfDay();
        long[] monthCounts = this.monthCountsByYear.get(year);
        long[] dayCounts = this.dayCountsByYear.get(year);
        if (monthCounts == null) {
            monthCounts = new long[12];
            this.monthCountsByYear.put(year, monthCounts);
            dayCounts = new long[this.daysInYear(year)];
            this.dayCountsByYear.put(year, dayCounts);
        }
        if ((hourCounts = this.hourCountsByDay.get(countsByDayKey = year * 1000 + day)) == null) {
            hourCounts = new long[24];
            this.hourCountsByDay.put(countsByDayKey, hourCounts);
        }
        if ((minuteCounts = this.minuteCountsByDay.get(countsByDayKey)) == null) {
            minuteCounts = new long[1440];
            this.minuteCountsByDay.put(countsByDayKey, minuteCounts);
        }
        int n = minute;
        minuteCounts[n] = minuteCounts[n] + amount;
        int n2 = month - 1;
        monthCounts[n2] = monthCounts[n2] + amount;
        int n3 = day - 1;
        dayCounts[n3] = dayCounts[n3] + amount;
        int n4 = hour;
        hourCounts[n4] = hourCounts[n4] + amount;
        return this.increment(amount);
    }
}

