/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.rest.controller;

import java.util.ArrayList;
import org.springframework.analytics.metrics.FieldValueCounter;
import org.springframework.analytics.metrics.FieldValueCounterRepository;
import org.springframework.analytics.rest.domain.FieldValueCounterResource;
import org.springframework.analytics.rest.domain.MetricResource;
import org.springframework.boot.actuate.endpoint.mvc.MetricsMvcEndpoint;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metrics/field-value-counters"})
@ExposesResourceFor(value=FieldValueCounterResource.class)
public class FieldValueCounterController {
    private final FieldValueCounterRepository repository;
    private DeepResourceAssembler deepAssembler = new DeepResourceAssembler();
    private ShallowResourceAssembler shallowAssembler = new ShallowResourceAssembler();

    public FieldValueCounterController(FieldValueCounterRepository repository) {
        this.repository = repository;
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    public FieldValueCounterResource display(@PathVariable(value="name") String name) {
        FieldValueCounter counter = this.repository.findOne(name);
        if (counter == null) {
            throw new MetricsMvcEndpoint.NoSuchMetricException(name);
        }
        return this.deepAssembler.toResource(counter);
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    protected void delete(@PathVariable(value="name") String name) {
        FieldValueCounter counter = this.repository.findOne(name);
        if (counter == null) {
            throw new MetricsMvcEndpoint.NoSuchMetricException(name);
        }
        this.repository.reset(name);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(PagedResourcesAssembler<String> pagedAssembler) {
        ArrayList<String> names = new ArrayList<String>(this.repository.list());
        return pagedAssembler.toResource((Page)new PageImpl(names), (ResourceAssembler)this.shallowAssembler);
    }

    private static class DeepResourceAssembler
    extends ResourceAssemblerSupport<FieldValueCounter, FieldValueCounterResource> {
        private DeepResourceAssembler() {
            super(FieldValueCounterController.class, FieldValueCounterResource.class);
        }

        public FieldValueCounterResource toResource(FieldValueCounter entity) {
            return (FieldValueCounterResource)this.createResourceWithId(entity.getName(), entity);
        }

        protected FieldValueCounterResource instantiateResource(FieldValueCounter entity) {
            return new FieldValueCounterResource(entity.getName(), entity.getFieldValueCounts());
        }
    }

    private static class ShallowResourceAssembler
    extends ResourceAssemblerSupport<String, MetricResource> {
        private ShallowResourceAssembler() {
            super(FieldValueCounterController.class, MetricResource.class);
        }

        public MetricResource toResource(String name) {
            return (MetricResource)this.createResourceWithId(name, name);
        }

        protected MetricResource instantiateResource(String name) {
            return new MetricResource(name);
        }
    }
}

