/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.analytics.rest.domain.MetricResource;

public class FieldValueCounterResource
extends MetricResource {
    private Map<String, Double> values;

    protected FieldValueCounterResource() {
    }

    public FieldValueCounterResource(String name, Map<String, Double> values) {
        super(name);
        this.setValues(values);
    }

    public Map<String, Double> getValues() {
        return this.values;
    }

    @JsonProperty
    public void setValues(Map<String, Double> values) {
        this.values = new TreeMap<String, Double>(new ByDecreasingValueComparator(values));
        this.values.putAll(values);
    }

    private static class ByDecreasingValueComparator
    implements Comparator<String> {
        private final Map<String, Double> values;

        private ByDecreasingValueComparator(Map<String, Double> values) {
            this.values = values;
        }

        @Override
        public int compare(String k1, String k2) {
            int byValue = this.values.get(k1).compareTo(this.values.get(k2));
            return byValue == 0 ? k1.compareTo(k2) : -byValue;
        }
    }
}

