/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics;

import java.util.Arrays;
import org.joda.time.Interval;
import org.springframework.analytics.metrics.AggregateCounterResolution;

public class AggregateCounter {
    private final String name;
    private final Interval interval;
    private final long[] counts;
    private final AggregateCounterResolution resolution;

    public AggregateCounter(String name, Interval interval, long[] counts, AggregateCounterResolution resolution) {
        this.name = name;
        this.interval = interval;
        this.counts = (long[])counts.clone();
        this.resolution = resolution;
    }

    public int getTotal() {
        int total = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            total = (int)((long)total + this.counts[i]);
        }
        return total;
    }

    public String getName() {
        return this.name;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public long[] getCounts() {
        return this.counts;
    }

    public AggregateCounterResolution getResolution() {
        return this.resolution;
    }

    public String toString() {
        return "AggregateCount{name='" + this.name + "', interval=" + this.interval + ", counts=" + Arrays.toString(this.counts) + ", resolution=" + (Object)((Object)this.resolution) + '}';
    }
}

