/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.analytics.rest.domain.Delta;
import org.springframework.analytics.rest.domain.Metric;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

public class RedisMetricRepository {
    private static final String DEFAULT_METRICS_PREFIX = "spring.metrics.";
    private static final String DEFAULT_KEY = "keys.spring.metrics";
    private String prefix = "spring.metrics.";
    private String key = "keys.spring.metrics";
    private BoundZSetOperations<String, String> zSetOperations;
    private final RedisOperations<String, String> redisOperations;

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory) {
        this(redisConnectionFactory, null);
    }

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory, String prefix) {
        this(redisConnectionFactory, prefix, null);
    }

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory, String prefix, String key) {
        if (prefix == null) {
            prefix = DEFAULT_METRICS_PREFIX;
            if (key == null) {
                key = DEFAULT_KEY;
            }
        } else if (key == null) {
            key = "keys." + prefix;
        }
        Assert.notNull((Object)redisConnectionFactory, (String)"RedisConnectionFactory must not be null");
        this.redisOperations = RedisMetricRepository.stringTemplate(redisConnectionFactory);
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        this.key = key;
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.key);
    }

    static <K, V> RedisTemplate<K, V> createRedisTemplate(RedisConnectionFactory connectionFactory, Class<V> valueClass) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(valueClass));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    static RedisOperations<String, String> stringTemplate(RedisConnectionFactory redisConnectionFactory) {
        return new StringRedisTemplate(redisConnectionFactory);
    }

    public Metric<?> findOne(String metricName) {
        String redisKey = this.keyFor(metricName);
        String raw = (String)this.redisOperations.opsForValue().get((Object)redisKey);
        return this.deserialize(redisKey, raw, this.zSetOperations.score((Object)redisKey));
    }

    public Iterable<Metric<?>> findAll() {
        Set keys = this.zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList result = new ArrayList(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            String key = (String)keysIt.next();
            Metric<?> value = this.deserialize(key, v, this.zSetOperations.score((Object)key));
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public long count() {
        return this.zSetOperations.size();
    }

    public void increment(Delta<?> delta) {
        String name = delta.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        double value = this.zSetOperations.incrementScore((Object)key, ((Number)delta.getValue()).doubleValue());
        String raw = this.serialize(new Metric<Double>(name, value, delta.getTimestamp()));
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    public void set(Metric<?> value) {
        String name = value.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        this.zSetOperations.add((Object)key, ((Number)value.getValue()).doubleValue());
        String raw = this.serialize(value);
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    public void reset(String metricName) {
        String key = this.keyFor(metricName);
        if (this.zSetOperations.remove(new Object[]{key}) == 1L) {
            this.redisOperations.delete((Object)key);
        }
    }

    private Metric<?> deserialize(String redisKey, String v, Double value) {
        if (redisKey == null || v == null || !redisKey.startsWith(this.prefix)) {
            return null;
        }
        Date timestamp = new Date(Long.valueOf(v));
        return new Metric<Double>(this.nameFor(redisKey), value, timestamp);
    }

    private String serialize(Metric<?> entity) {
        return String.valueOf(entity.getTimestamp().getTime());
    }

    private String keyFor(String name) {
        return this.prefix + name;
    }

    private String nameFor(String redisKey) {
        return redisKey.substring(this.prefix.length());
    }

    private void trackMembership(String redisKey) {
        this.zSetOperations.incrementScore((Object)redisKey, 0.0);
    }
}

