/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.rest.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.springframework.analytics.metrics.AggregateCounter;
import org.springframework.analytics.metrics.AggregateCounterRepository;
import org.springframework.analytics.metrics.AggregateCounterResolution;
import org.springframework.analytics.rest.controller.NoSuchMetricException;
import org.springframework.analytics.rest.domain.AggregateCounterResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metrics/aggregate-counters"})
@ExposesResourceFor(value=AggregateCounterResource.class)
public class AggregateCounterController {
    private final AggregateCounterRepository repository;
    private DeepResourceAssembler deepAssembler = new DeepResourceAssembler();
    private ShallowResourceAssembler shallowAssembler = new ShallowResourceAssembler();

    public AggregateCounterController(AggregateCounterRepository repository) {
        this.repository = repository;
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    public AggregateCounterResource display(@PathVariable(value="name") String name) {
        AggregateCounter counter = this.repository.findOne(name);
        if (counter == null) {
            throw new NoSuchMetricException(name);
        }
        return this.deepAssembler.toResource(counter);
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    protected void delete(@PathVariable(value="name") String name) {
        AggregateCounter counter = this.repository.findOne(name);
        if (counter == null) {
            throw new NoSuchMetricException(name);
        }
        this.repository.reset(name);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<AggregateCounterResource> list(Pageable pageable, PagedResourcesAssembler<String> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime from, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime to, @RequestParam(value="resolution", defaultValue="hour") AggregateCounterResolution resolution) {
        ArrayList<String> names = new ArrayList<String>(this.repository.list());
        long count = names.size();
        long pageEnd = Math.min(count, pageable.getOffset() + (long)pageable.getPageSize());
        PageImpl aggregateCounterPage = new PageImpl(names.subList(Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageEnd)), pageable, (long)names.size());
        PagedResources resources = pagedAssembler.toResource((Page)aggregateCounterPage, (ResourceAssembler)this.shallowAssembler);
        if (detailed) {
            to = this.providedOrDefaultToValue(to);
            from = this.providedOrDefaultFromValue(from, to, resolution);
            Interval interval = new Interval((ReadableInstant)from, (ReadableInstant)to);
            LinkedList<AggregateCounterResource> aggregateCounts = new LinkedList<AggregateCounterResource>();
            for (AggregateCounterResource aggregateCounterResource : resources) {
                AggregateCounter aggregateCount = this.repository.getCounts(aggregateCounterResource.getName(), interval, resolution);
                aggregateCounts.add(this.deepAssembler.toResource(aggregateCount));
            }
            return new PagedResources(aggregateCounts, resources.getMetadata(), new Link[0]);
        }
        return resources;
    }

    @ResponseBody
    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    public AggregateCounterResource display(@PathVariable(value="name") String name, @RequestParam(value="from", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime from, @RequestParam(value="to", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) DateTime to, @RequestParam(value="resolution", defaultValue="hour") AggregateCounterResolution resolution) {
        to = this.providedOrDefaultToValue(to);
        from = this.providedOrDefaultFromValue(from, to, resolution);
        AggregateCounter aggregate = this.repository.getCounts(name, new Interval((ReadableInstant)from, (ReadableInstant)to), resolution);
        return this.deepAssembler.toResource(aggregate);
    }

    private DateTime providedOrDefaultToValue(DateTime to) {
        if (to == null) {
            to = new DateTime();
        }
        return to;
    }

    private DateTime providedOrDefaultFromValue(DateTime from, DateTime to, AggregateCounterResolution resolution) {
        if (from != null) {
            return from;
        }
        switch (resolution) {
            case minute: {
                return to.minusMinutes(59);
            }
            case hour: {
                return to.minusHours(23);
            }
            case day: {
                return to.minusDays(6);
            }
            case month: {
                return to.minusMonths(11);
            }
            case year: {
                return to.minusYears(4);
            }
        }
        throw new IllegalStateException("Shouldn't happen. Unhandled resolution: " + (Object)((Object)resolution));
    }

    private static class DeepResourceAssembler
    extends ResourceAssemblerSupport<AggregateCounter, AggregateCounterResource> {
        private DeepResourceAssembler() {
            super(AggregateCounterController.class, AggregateCounterResource.class);
        }

        public AggregateCounterResource toResource(AggregateCounter entity) {
            return (AggregateCounterResource)this.createResourceWithId(entity.getName(), entity);
        }

        protected AggregateCounterResource instantiateResource(AggregateCounter entity) {
            AggregateCounterResource result = new AggregateCounterResource(entity.getName());
            ReadablePeriod increment = entity.getResolution().unitPeriod;
            DateTime end = entity.getInterval().getEnd();
            int i = 0;
            DateTime when = entity.getInterval().getStart();
            while (!when.isAfter((ReadableInstant)end)) {
                result.addValue(new Date(when.getMillis()), entity.getCounts()[i++]);
                when = when.plus(increment);
            }
            return result;
        }
    }

    private static class ShallowResourceAssembler
    extends ResourceAssemblerSupport<String, AggregateCounterResource> {
        private ShallowResourceAssembler() {
            super(AggregateCounterController.class, AggregateCounterResource.class);
        }

        public AggregateCounterResource toResource(String name) {
            return (AggregateCounterResource)this.createResourceWithId(name, name);
        }

        protected AggregateCounterResource instantiateResource(String name) {
            return new AggregateCounterResource(name);
        }
    }
}

