/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.web.util.ResourceInfo;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class AnnotationMappingMetaDataController
implements ApplicationContextAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(AnnotationMappingMetaDataController.class);
    private ApplicationContext applicationContext;
    private Set<String> urls;
    private List<ResourceInfo> resources;
    private String servletPath;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, Object> handlerMap = new HashMap<String, Object>();
        DefaultAnnotationHandlerMapping annotationMapping = new DefaultAnnotationHandlerMapping();
        annotationMapping.setApplicationContext(this.applicationContext);
        annotationMapping.initApplicationContext();
        handlerMap.putAll(annotationMapping.getHandlerMap());
        BeanNameUrlHandlerMapping beanMapping = new BeanNameUrlHandlerMapping();
        beanMapping.setApplicationContext(this.applicationContext);
        beanMapping.initApplicationContext();
        handlerMap.putAll(beanMapping.getHandlerMap());
        this.urls = this.findUniqueUrls(handlerMap.keySet());
        this.resources = this.findMethods(handlerMap, this.urls);
    }

    private List<ResourceInfo> findMethods(Map<String, Object> handlerMap, Set<String> urls) {
        TreeSet<ResourceInfo> result = new TreeSet<ResourceInfo>();
        for (String key : urls) {
            Object handler = handlerMap.get(key);
            Class handlerType = ClassUtils.getUserClass((Object)handler);
            HandlerMethodResolver resolver = new HandlerMethodResolver();
            resolver.init(handlerType);
            String[] typeMappings = null;
            RequestMapping typeMapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)handlerType, RequestMapping.class);
            if (typeMapping != null) {
                typeMappings = typeMapping.value();
            }
            Set handlerMethods = resolver.getHandlerMethods();
            for (Method method : handlerMethods) {
                RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                HashSet<String> computedMappings = new HashSet<String>();
                if (typeMappings != null) {
                    computedMappings.addAll(Arrays.asList(typeMappings));
                }
                for (String path : mapping.value()) {
                    if (typeMappings != null) {
                        for (String parent : computedMappings) {
                            if (parent.endsWith("/")) {
                                parent = parent.substring(0, parent.length() - 1);
                            }
                            computedMappings.add(parent + path);
                        }
                        continue;
                    }
                    computedMappings.add(path);
                }
                logger.debug((Object)("Analysing mappings for method:" + method.getName() + ", key:" + key + ", computed mappings: " + computedMappings));
                if (!computedMappings.contains(key)) continue;
                RequestMethod[] methods = mapping.method();
                if (methods != null && methods.length > 0) {
                    for (RequestMethod requestMethod : methods) {
                        logger.debug((Object)("Added explicit mapping for path=" + key + "to RequestMethod=" + requestMethod));
                        result.add(new ResourceInfo(key, requestMethod));
                    }
                    continue;
                }
                logger.debug((Object)("Added implicit mapping for path=" + key + "to RequestMethod=GET"));
                result.add(new ResourceInfo(key, RequestMethod.GET));
            }
            if (!handlerMethods.isEmpty()) continue;
            result.add(new ResourceInfo(key, RequestMethod.GET));
        }
        return new ArrayList<ResourceInfo>(result);
    }

    private Set<String> findUniqueUrls(Collection<String> inputs) {
        HashSet<String> result = new HashSet<String>(inputs);
        for (String url : inputs) {
            String extended = url + ".*";
            if (inputs.contains(extended)) {
                result.remove(extended);
            }
            if (!inputs.contains(extended = url + "/")) continue;
            result.remove(extended);
        }
        return result;
    }

    @RequestMapping(value={"/home"}, method={RequestMethod.GET})
    @ModelAttribute(value="resources")
    public List<ResourceInfo> getResources(HttpServletRequest request) {
        String servletPath = this.servletPath;
        if (servletPath == null) {
            servletPath = new UrlPathHelper().getServletPath(request);
        }
        request.setAttribute("servletPath", (Object)servletPath);
        return this.resources;
    }

    public Set<String> getUrlPatterns() {
        return this.urls;
    }
}

