/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.js.ajax.freemarker;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFreeMarkerView
extends FreeMarkerView {
    private static final String FRAGMENTS_PARAM = "fragments";
    private AjaxHandler ajaxHandler = new SpringJavascriptAjaxHandler();
    private ViewResolver viewResolver;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            String[] attrNames = this.getRenderFragments(model, request, response);
            if (attrNames.length == 0) {
                this.logger.warn((Object)"An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.");
                super.renderMergedTemplateModel(model, request, response);
            }
            request.getSession();
            response.flushBuffer();
            for (int i = 0; i < attrNames.length; ++i) {
                View fragmentView;
                block7: {
                    fragmentView = null;
                    try {
                        fragmentView = (View)this.getApplicationContext().getBean(attrNames[i], View.class);
                    }
                    catch (Exception e) {
                        if (!this.getAttributesMap().containsKey(attrNames[i])) break block7;
                        String viewName = (String)this.getAttributesMap().get(attrNames[i]);
                        fragmentView = this.viewResolver.resolveViewName(viewName, RequestContextUtils.getLocale((HttpServletRequest)request));
                    }
                }
                if (fragmentView == null) {
                    throw new ServletException("No View with a name of '" + attrNames[i] + "' could be found: " + (Object)((Object)this));
                }
                fragmentView.render(model, request, response);
            }
        } else {
            super.renderMergedTemplateModel(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        String attrName = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)attrName);
        return StringUtils.trimArrayElements((String[])renderFragments);
    }
}

