/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.NoWorkFoundException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MultiResourceItemReader
extends ExecutionContextUserSupport
implements ItemReader,
ItemStream,
InitializingBean {
    private static final Object END_OF_RESOURCE_MARKER = new Object();
    private ResourceAwareItemReaderItemStream delegate;
    private Resource[] resources;
    private MultiResourceIndex index = new MultiResourceIndex();
    private List itemBuffer = new ArrayList();
    private ListIterator itemBufferIterator = null;
    private boolean shouldReadBuffer = false;
    private boolean saveState = false;
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Resource r1 = (Resource)o1;
            Resource r2 = (Resource)o2;
            return r1.getFilename().compareTo(r2.getFilename());
        }
    };

    public MultiResourceItemReader() {
        this.setName(ClassUtils.getShortName((Class)MultiResourceItemReader.class));
    }

    public Object read() throws Exception, UnexpectedInputException, NoWorkFoundException, ParseException {
        Object item = this.shouldReadBuffer ? this.readBufferedItem() : this.readNextItem();
        this.index.incrementItemCount();
        return item;
    }

    private Object readNextItem() throws Exception {
        Object item = this.delegate.read();
        while (item == null) {
            this.index.incrementResourceCount();
            if (this.index.currentResource >= this.resources.length) {
                return null;
            }
            this.itemBuffer.add(END_OF_RESOURCE_MARKER);
            this.delegate.close(new ExecutionContext());
            this.delegate.setResource(this.resources[this.index.currentResource]);
            this.delegate.open(new ExecutionContext());
            item = this.delegate.read();
        }
        this.itemBuffer.add(item);
        return item;
    }

    private Object readBufferedItem() {
        Object buffered = this.itemBufferIterator.next();
        while (buffered == END_OF_RESOURCE_MARKER) {
            this.index.incrementResourceCount();
            buffered = this.itemBufferIterator.next();
        }
        if (!this.itemBufferIterator.hasNext()) {
            this.shouldReadBuffer = false;
            this.itemBufferIterator = null;
        }
        return buffered;
    }

    public void mark() throws MarkFailedException {
        this.emptyBuffer();
        this.index.mark();
        this.delegate.mark();
    }

    private void emptyBuffer() {
        if (!this.shouldReadBuffer) {
            this.itemBuffer.clear();
            this.itemBufferIterator = null;
        } else {
            this.itemBuffer = this.itemBuffer.subList(this.itemBufferIterator.nextIndex(), this.itemBuffer.size());
            this.itemBufferIterator = this.itemBuffer.listIterator();
        }
    }

    public void reset() throws ResetFailedException {
        if (!this.itemBuffer.isEmpty()) {
            this.shouldReadBuffer = true;
            this.itemBufferIterator = this.itemBuffer.listIterator();
        }
        this.index.reset();
    }

    public void close(ExecutionContext executionContext) throws ItemStreamException {
        this.shouldReadBuffer = false;
        this.itemBufferIterator = null;
        this.index = new MultiResourceIndex();
        this.itemBuffer.clear();
        this.delegate.close(new ExecutionContext());
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        Arrays.sort(this.resources, this.comparator);
        this.index.open(executionContext);
        this.delegate.setResource(this.resources[this.index.currentResource]);
        this.delegate.open(new ExecutionContext());
        try {
            int i = 0;
            while ((long)i < this.index.currentItem) {
                this.delegate.read();
                this.delegate.mark();
                ++i;
            }
        }
        catch (Exception e) {
            throw new ItemStreamException("Could not restore position on restart", e);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            this.index.update(executionContext);
        }
    }

    public void setDelegate(ResourceAwareItemReaderItemStream delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Object[])this.resources, (String)"There must be at least one input resource");
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    private class MultiResourceIndex {
        private static final String RESOURCE_KEY = "resourceIndex";
        private static final String ITEM_KEY = "itemIndex";
        private int currentResource = 0;
        private int markedResource = 0;
        private long currentItem = 0L;
        private long markedItem = 0L;

        private MultiResourceIndex() {
        }

        public void incrementItemCount() {
            ++this.currentItem;
        }

        public void incrementResourceCount() {
            ++this.currentResource;
            this.currentItem = 0L;
        }

        public void mark() {
            this.markedResource = this.currentResource;
            this.markedItem = this.currentItem;
        }

        public void reset() {
            this.currentResource = this.markedResource;
            this.currentItem = this.markedItem;
        }

        public void open(ExecutionContext ctx) {
            if (ctx.containsKey(MultiResourceItemReader.this.getKey(RESOURCE_KEY))) {
                this.currentResource = Long.valueOf(ctx.getLong(MultiResourceItemReader.this.getKey(RESOURCE_KEY))).intValue();
            }
            if (ctx.containsKey(MultiResourceItemReader.this.getKey(ITEM_KEY))) {
                this.currentItem = ctx.getLong(MultiResourceItemReader.this.getKey(ITEM_KEY));
            }
        }

        public void update(ExecutionContext ctx) {
            ctx.putLong(MultiResourceItemReader.this.getKey(RESOURCE_KEY), ((MultiResourceItemReader)MultiResourceItemReader.this).index.currentResource);
            ctx.putLong(MultiResourceItemReader.this.getKey(ITEM_KEY), ((MultiResourceItemReader)MultiResourceItemReader.this).index.currentItem);
        }
    }
}

