/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPagingItemReader<T>
extends AbstractPagingItemReader<T>
implements InitializingBean {
    public static final int VALUE_NOT_SET = -1;
    private DataSource dataSource;
    private PagingQueryProvider queryProvider;
    private Map<String, Object> parameterValues;
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private RowMapper rowMapper;
    private String firstPageSql;
    private String remainingPagesSql;
    private Object startAfterValue;
    private int fetchSize = -1;

    public JdbcPagingItemReader() {
        this.setName(ClassUtils.getShortName(JdbcPagingItemReader.class));
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryProvider(PagingQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.dataSource);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (this.fetchSize != -1) {
            jdbcTemplate.setFetchSize(this.fetchSize);
        }
        jdbcTemplate.setMaxRows(this.pageSize);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate((JdbcOperations)jdbcTemplate);
        Assert.notNull((Object)this.queryProvider);
        this.queryProvider.init(this.dataSource);
        this.firstPageSql = this.queryProvider.generateFirstPageQuery(this.pageSize);
        this.remainingPagesSql = this.queryProvider.generateRemainingPagesQuery(this.pageSize);
    }

    @Override
    protected void doReadPage() {
        if (this.results == null) {
            this.results = new ArrayList();
        } else {
            this.results.clear();
        }
        if (this.page == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL used for reading first page: [" + this.firstPageSql + "]"));
            }
            if (this.parameterValues != null && this.parameterValues.size() > 0) {
                if (this.queryProvider.isUsingNamedParameters()) {
                    this.simpleJdbcTemplate.getNamedParameterJdbcOperations().query(this.firstPageSql, this.getParameterMap(this.parameterValues, null), new RowCallbackHandler(){

                        public void processRow(ResultSet rs) throws SQLException {
                            JdbcPagingItemReader.this.startAfterValue = rs.getObject(1);
                            JdbcPagingItemReader.this.results.add(JdbcPagingItemReader.this.rowMapper.mapRow(rs, JdbcPagingItemReader.this.results.size()));
                        }
                    });
                } else {
                    this.simpleJdbcTemplate.getJdbcOperations().query(this.firstPageSql, this.getParameterList(this.parameterValues, null).toArray(), (RowCallbackHandler)new PagingRowCallbackHandler());
                }
            } else {
                this.simpleJdbcTemplate.getJdbcOperations().query(this.firstPageSql, (RowCallbackHandler)new PagingRowCallbackHandler());
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL used for reading remaining pages: [" + this.remainingPagesSql + "]"));
            }
            if (this.queryProvider.isUsingNamedParameters()) {
                this.simpleJdbcTemplate.getNamedParameterJdbcOperations().query(this.remainingPagesSql, this.getParameterMap(this.parameterValues, this.startAfterValue), (RowCallbackHandler)new PagingRowCallbackHandler());
            } else {
                this.simpleJdbcTemplate.getJdbcOperations().query(this.remainingPagesSql, this.getParameterList(this.parameterValues, this.startAfterValue).toArray(), (RowCallbackHandler)new PagingRowCallbackHandler());
            }
        }
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
        if (this.page > 0) {
            String jumpToItemSql = this.queryProvider.generateJumpToItemQuery(itemIndex, this.pageSize);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL used for jumping: [" + jumpToItemSql + "]"));
            }
            this.startAfterValue = this.simpleJdbcTemplate.getJdbcOperations().queryForObject(jumpToItemSql, new RowMapper(){

                public Object mapRow(ResultSet rs, int i) throws SQLException {
                    return rs.getObject(1);
                }
            });
        }
    }

    private Map<String, Object> getParameterMap(Map<String, Object> values, Object sortKeyValue) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (values != null) {
            parameterMap.putAll(values);
        }
        if (sortKeyValue != null) {
            parameterMap.put("_sortKey", sortKeyValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using parameterMap:" + parameterMap));
        }
        return parameterMap;
    }

    private List<Object> getParameterList(Map<String, Object> values, Object sortKeyValue) {
        TreeMap<String, Object> sm = new TreeMap<String, Object>();
        if (values != null) {
            sm.putAll(values);
        }
        ArrayList<Object> parameterList = new ArrayList<Object>();
        parameterList.addAll(sm.values());
        if (sortKeyValue != null) {
            parameterList.add(sortKeyValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using parameterList:" + parameterList));
        }
        return parameterList;
    }

    private class PagingRowCallbackHandler
    implements RowCallbackHandler {
        private PagingRowCallbackHandler() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            JdbcPagingItemReader.this.startAfterValue = rs.getObject(1);
            JdbcPagingItemReader.this.results.add(JdbcPagingItemReader.this.rowMapper.mapRow(rs, JdbcPagingItemReader.this.results.size()));
        }
    }
}

