/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    private List<ItemProcessor> itemProcessors;

    @Override
    public O process(I item) throws Exception {
        Object result = item;
        for (ItemProcessor transformer : this.itemProcessors) {
            if (result == null) {
                return null;
            }
            result = transformer.process(result);
        }
        return (O)result;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.itemProcessors);
    }

    public void setItemProcessors(List<ItemProcessor> itemProcessors) {
        this.itemProcessors = itemProcessors;
    }
}

