/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.mapping.PropertyMatches;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.support.DefaultPropertyEditorRegistrar;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.DataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapperFieldSetMapper<T>
extends DefaultPropertyEditorRegistrar
implements FieldSetMapper<T>,
BeanFactoryAware,
InitializingBean {
    private String name;
    private Class<? extends T> type;
    private BeanFactory beanFactory;
    private static Map<DistanceHolder, Map<String, String>> propertiesMatched = new HashMap<DistanceHolder, Map<String, String>>();
    private int distanceLimit = 5;
    private boolean strict = true;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setDistanceLimit(int distanceLimit) {
        this.distanceLimit = distanceLimit;
    }

    public void setPrototypeBeanName(String name) {
        this.name = name;
    }

    public void setTargetType(Class<? extends T> type) {
        this.type = type;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.name != null || this.type != null ? 1 : 0) != 0, (String)"Either name or type must be provided.");
        Assert.state((this.name == null || this.type == null ? 1 : 0) != 0, (String)"Both name and type cannot be specified together.");
    }

    @Override
    public T mapFieldSet(FieldSet fs) throws BindException {
        T copy = this.getBean();
        DataBinder binder = this.createBinder(copy);
        binder.bind((PropertyValues)new MutablePropertyValues((Map)this.getBeanProperties(copy, fs.getProperties())));
        if (binder.getBindingResult().hasErrors()) {
            throw new BindException(binder.getBindingResult());
        }
        return copy;
    }

    protected DataBinder createBinder(Object target) {
        DataBinder binder = new DataBinder(target);
        binder.setIgnoreUnknownFields(!this.strict);
        this.initBinder(binder);
        this.registerCustomEditors((PropertyEditorRegistry)binder);
        return binder;
    }

    protected void initBinder(DataBinder binder) {
    }

    private T getBean() {
        if (this.name != null) {
            return (T)this.beanFactory.getBean(this.name);
        }
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        throw new IllegalStateException("Internal error: could not create bean instance for mapping.");
    }

    private Properties getBeanProperties(Object bean, Properties properties) {
        Class<?> cls = bean.getClass();
        DistanceHolder distanceKey = new DistanceHolder(cls, this.distanceLimit);
        Map<String, String> matches = propertiesMatched.get(distanceKey);
        if (matches == null) {
            matches = new HashMap<String, String>();
            propertiesMatched.put(distanceKey, matches);
        }
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        for (String string : keys) {
            if (matches.containsKey(string)) {
                this.switchPropertyNames(properties, string, matches.get(string));
                continue;
            }
            String name = this.findPropertyName(bean, string);
            if (name == null) continue;
            if (matches.containsValue(name)) {
                throw new NotWritablePropertyException(cls, name, "Duplicate match with distance <= " + this.distanceLimit + " found for this property in input keys: " + keys + ". (Consider reducing the distance limit or changing the input key names to get a closer match.)");
            }
            matches.put(string, name);
            this.switchPropertyNames(properties, string, name);
        }
        return properties;
    }

    private String findPropertyName(Object bean, String key) {
        String suffix;
        String prefix;
        if (bean == null) {
            return null;
        }
        Class<?> cls = bean.getClass();
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)key);
        if (index > 0) {
            String prefix2 = key.substring(0, index);
            String suffix2 = key.substring(index + 1, key.length());
            String nestedName = this.findPropertyName(bean, prefix2);
            if (nestedName == null) {
                return null;
            }
            Object nestedValue = this.getPropertyValue(bean, nestedName);
            String nestedPropertyName = this.findPropertyName(nestedValue, suffix2);
            return nestedPropertyName == null ? null : nestedName + "." + nestedPropertyName;
        }
        String name = null;
        int distance = 0;
        index = key.indexOf(91);
        if (index > 0) {
            prefix = key.substring(0, index);
            suffix = key.substring(index);
        } else {
            prefix = key;
            suffix = "";
        }
        while (name == null && distance <= this.distanceLimit) {
            String[] candidates = PropertyMatches.forProperty(prefix, cls, distance).getPossibleMatches();
            if (candidates.length == 1) {
                String candidate = candidates[0];
                name = candidate.equals(prefix) ? key : candidate + suffix;
            }
            ++distance;
        }
        return name;
    }

    private Object getPropertyValue(Object bean, String nestedName) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
        Object nestedValue = wrapper.getPropertyValue(nestedName);
        if (nestedValue == null) {
            try {
                nestedValue = wrapper.getPropertyType(nestedName).newInstance();
                wrapper.setPropertyValue(nestedName, nestedValue);
            }
            catch (InstantiationException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
            catch (IllegalAccessException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
        }
        return nestedValue;
    }

    private void switchPropertyNames(Properties properties, String oldName, String newName) {
        String value = properties.getProperty(oldName);
        properties.remove(oldName);
        properties.setProperty(newName, value);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistanceHolder {
        private final Class<?> cls;
        private final int distance;

        public DistanceHolder(Class<?> cls, int distance) {
            this.cls = cls;
            this.distance = distance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + this.distance;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DistanceHolder other = (DistanceHolder)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return this.distance == other.distance;
        }
    }
}

