/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.xml.StaxEventItemReader;
import org.springframework.batch.item.xml.StaxEventItemWriter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class StaxUtils {
    private static final Log logger = LogFactory.getLog(StaxUtils.class);
    private static ClassLoader defaultClassLoader = ClassUtils.getDefaultClassLoader();
    private static String staxSourceClassNameOnSpringWs15 = "org.springframework.xml.transform.StaxSource";
    private static String staxResultClassNameOnSpringOxm15 = "org.springframework.xml.transform.StaxResult";
    private static String staxSourceClassNameOnSpringOxm30 = "org.springframework.util.xml.StaxUtils";
    private static boolean hasSpringWs15StaxSupport = ClassUtils.isPresent((String)staxSourceClassNameOnSpringWs15, (ClassLoader)defaultClassLoader);
    private static boolean hasSpring30StaxSupport = ClassUtils.isPresent((String)staxSourceClassNameOnSpringOxm30, (ClassLoader)defaultClassLoader);
    private static Method staxUtilsSourceMethodOnSpring30;
    private static Method staxUtilsResultMethodOnSpring30;
    private static Constructor<?> staxSourceClassCtorOnSpringWs15;
    private static Constructor<?> staxResultClassCtorOnSpringWs15;

    public static Source getSource(XMLEventReader r) throws Exception {
        if (hasSpring30StaxSupport) {
            Object result = staxUtilsSourceMethodOnSpring30.invoke(null, r);
            Assert.isInstanceOf(Source.class, (Object)result, (String)("the result should be assignable to " + Source.class.getName()));
            return (Source)result;
        }
        if (hasSpringWs15StaxSupport) {
            Object result = staxSourceClassCtorOnSpringWs15.newInstance(r);
            Assert.isInstanceOf(Source.class, result, (String)("the result should be assignable to " + Source.class.getName()));
            return (Source)result;
        }
        return null;
    }

    public static Result getResult(XMLEventWriter w) throws Exception {
        if (hasSpring30StaxSupport) {
            Object result = staxUtilsResultMethodOnSpring30.invoke(null, w);
            Assert.isInstanceOf(Result.class, (Object)result, (String)("the result should be assignable to " + Result.class.getName()));
            return (Result)result;
        }
        if (hasSpringWs15StaxSupport) {
            Object result = staxResultClassCtorOnSpringWs15.newInstance(w);
            Assert.isInstanceOf(Result.class, result, (String)("the result should be assignable to " + Result.class.getName()));
            return (Result)result;
        }
        return null;
    }

    public static XMLEventWriter getXmlEventWriter(Result r) throws Exception {
        Method m = r.getClass().getDeclaredMethod("getXMLEventWriter", new Class[0]);
        boolean accessible = m.isAccessible();
        m.setAccessible(true);
        Object result = m.invoke((Object)r, new Object[0]);
        m.setAccessible(accessible);
        return (XMLEventWriter)result;
    }

    public static XMLEventReader getXmlEventReader(Source s) throws Exception {
        Method m = s.getClass().getDeclaredMethod("getXMLEventReader", new Class[0]);
        boolean accessible = m.isAccessible();
        m.setAccessible(true);
        Object result = m.invoke((Object)s, new Object[0]);
        m.setAccessible(accessible);
        return (XMLEventReader)result;
    }

    static {
        try {
            if (hasSpring30StaxSupport) {
                Class clzz = ClassUtils.forName((String)staxSourceClassNameOnSpringOxm30, (ClassLoader)defaultClassLoader);
                staxUtilsSourceMethodOnSpring30 = ClassUtils.getStaticMethod((Class)clzz, (String)"createStaxSource", (Class[])new Class[]{XMLEventReader.class});
                staxUtilsResultMethodOnSpring30 = ClassUtils.getStaticMethod((Class)clzz, (String)"createStaxResult", (Class[])new Class[]{XMLEventWriter.class});
            } else if (hasSpringWs15StaxSupport) {
                Class staxSourceClassOnSpringWs15 = ClassUtils.forName((String)staxSourceClassNameOnSpringWs15, (ClassLoader)defaultClassLoader);
                staxSourceClassCtorOnSpringWs15 = staxSourceClassOnSpringWs15.getConstructor(XMLEventReader.class);
                Class staxResultClassOnSpringWs15 = ClassUtils.forName((String)staxResultClassNameOnSpringOxm15, (ClassLoader)defaultClassLoader);
                staxResultClassCtorOnSpringWs15 = staxResultClassOnSpringWs15.getConstructor(XMLEventWriter.class);
            } else {
                logger.debug((Object)("'StaxSource' was not detected in Spring 3.0's OXM support or Spring WS 1.5's OXM support. This is a problem if you intend to use the " + StaxEventItemWriter.class.getName() + " or " + StaxEventItemReader.class.getName() + ". Please add the appropriate dependencies."));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Could not precache required class and method metadata in " + StaxUtils.class.getName()));
        }
    }
}

