/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.BatchResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.util.Assert;

@Deprecated
public class IbatisBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(IbatisBatchItemWriter.class);
    private String statementId;
    private boolean assertUpdates = true;
    private SqlMapClient sqlMapClient;
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sqlMapClient, (String)"A SqlMapClient is required.");
        Assert.notNull((Object)this.statementId, (String)"A statementId is required.");
    }

    @Override
    public void write(List<? extends T> items) {
        if (!items.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing batch with " + items.size() + " items."));
            }
            List<BatchResult> results = this.execute(items);
            if (this.assertUpdates) {
                if (results.size() != 1) {
                    throw new InvalidDataAccessResourceUsageException("Batch execution returned invalid results. Expected 1 but number of BatchResult objects returned was " + results.size());
                }
                int[] updateCounts = results.get(0).getUpdateCounts();
                for (int i = 0; i < updateCounts.length; ++i) {
                    int value = updateCounts[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.get(i) + "]", 1);
                }
            }
        }
    }

    private List<BatchResult> execute(List<? extends T> items) {
        SqlMapSession session = this.sqlMapClient.openSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opened SqlMapSession [" + session + "] for iBATIS operation"));
        }
        Connection ibatisCon = null;
        try {
            Connection springCon = null;
            boolean transactionAware = this.dataSource instanceof TransactionAwareDataSourceProxy;
            try {
                ibatisCon = session.getCurrentConnection();
                if (ibatisCon == null) {
                    springCon = transactionAware ? this.dataSource.getConnection() : DataSourceUtils.doGetConnection((DataSource)this.dataSource);
                    session.setUserConnection(springCon);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Obtained JDBC Connection [" + springCon + "] for iBATIS operation"));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation"));
                }
            }
            catch (SQLException ex) {
                throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", ex);
            }
            session.startBatch();
            for (T item : items) {
                session.update(this.statementId, item);
            }
            try {
                List ex = session.executeBatchDetailed();
                return ex;
            }
            catch (BatchException e) {
                try {
                    throw e.getBatchUpdateException();
                }
                catch (SQLException ex) {
                    Object sqlStateSQLExceptionTranslator = this.dataSource != null ? new SQLStateSQLExceptionTranslator() : new SQLErrorCodeSQLExceptionTranslator(this.dataSource);
                    throw sqlStateSQLExceptionTranslator.translate("SqlMapClient operation", null, ex);
                }
            }
        }
        finally {
            if (ibatisCon == null) {
                session.close();
            }
        }
    }
}

