/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.mongodb.util.json.ParameterBindingJsonReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoItemReader<T>
extends AbstractPaginatedDataItemReader<T>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MongoItemReader.class);
    private MongoOperations template;
    private Query query;
    private String queryString;
    private Class<? extends T> type;
    private Sort sort;
    private String hint;
    private String fields;
    private String collection;
    private List<Object> parameterValues = new ArrayList<Object>();

    public MongoItemReader() {
        this.setName(ClassUtils.getShortName(MongoItemReader.class));
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    public void setQuery(String queryString) {
        this.queryString = queryString;
    }

    public void setTargetType(Class<? extends T> type) {
        this.type = type;
    }

    public void setParameterValues(List<Object> parameterValues) {
        Assert.notNull(parameterValues, (String)"Parameter values must not be null");
        this.parameterValues = parameterValues;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        Assert.notNull(sorts, (String)"Sorts must not be null");
        this.sort = this.convertToSort(sorts);
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    protected Iterator<T> doPageRead() {
        if (this.queryString != null) {
            PageRequest pageRequest = PageRequest.of((int)this.page, (int)this.pageSize, (Sort)this.sort);
            String populatedQuery = this.replacePlaceholders(this.queryString, this.parameterValues);
            BasicQuery mongoQuery = StringUtils.hasText((String)this.fields) ? new BasicQuery(populatedQuery, this.fields) : new BasicQuery(populatedQuery);
            mongoQuery.with((Pageable)pageRequest);
            if (StringUtils.hasText((String)this.hint)) {
                mongoQuery.withHint(this.hint);
            }
            if (StringUtils.hasText((String)this.collection)) {
                return this.template.find((Query)mongoQuery, this.type, this.collection).iterator();
            }
            return this.template.find((Query)mongoQuery, this.type).iterator();
        }
        PageRequest pageRequest = PageRequest.of((int)this.page, (int)this.pageSize);
        this.query.with((Pageable)pageRequest);
        if (StringUtils.hasText((String)this.collection)) {
            return this.template.find(this.query, this.type, this.collection).iterator();
        }
        return this.template.find(this.query, this.type).iterator();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.template != null ? 1 : 0) != 0, (String)"An implementation of MongoOperations is required.");
        Assert.state((this.type != null ? 1 : 0) != 0, (String)"A type to convert the input into is required.");
        Assert.state((this.queryString != null || this.query != null ? 1 : 0) != 0, (String)"A query is required.");
        if (this.queryString != null) {
            Assert.state((this.sort != null ? 1 : 0) != 0, (String)"A sort is required.");
        }
    }

    private String replacePlaceholders(String input, List<Object> values) {
        ParameterBindingJsonReader reader = new ParameterBindingJsonReader(input, values.toArray());
        DecoderContext decoderContext = DecoderContext.builder().build();
        Document document = new ParameterBindingDocumentCodec().decode((BsonReader)reader, decoderContext);
        return document.toJson();
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>(sorts.size());
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return Sort.by(sortValues);
    }
}

