/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import org.springframework.batch.item.file.transform.FlatFileFormatException;

public class IncorrectLineLengthException
extends FlatFileFormatException {
    private int actualLength;
    private int expectedLength;

    public IncorrectLineLengthException(String message, int expectedLength, int actualLength, String input) {
        super(message, input);
        this.expectedLength = expectedLength;
        this.actualLength = actualLength;
    }

    public IncorrectLineLengthException(String message, int expectedLength, int actualLength) {
        super(message);
        this.expectedLength = expectedLength;
        this.actualLength = actualLength;
    }

    public IncorrectLineLengthException(int expectedLength, int actualLength, String input) {
        super("Incorrect line length in record: expected " + expectedLength + " actual " + actualLength, input);
        this.actualLength = actualLength;
        this.expectedLength = expectedLength;
    }

    public IncorrectLineLengthException(int expectedLength, int actualLength) {
        super("Incorrect line length in record: expected " + expectedLength + " actual " + actualLength);
        this.actualLength = actualLength;
        this.expectedLength = expectedLength;
    }

    public int getActualLength() {
        return this.actualLength;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }
}

