/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.LinkedHashMap;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.classify.Classifier;
import org.springframework.classify.ClassifierSupport;
import org.springframework.util.Assert;

public class ClassifierCompositeItemWriter<T>
implements ItemWriter<T> {
    private Classifier<T, ItemWriter<? super T>> classifier = new ClassifierSupport(null);

    public void setClassifier(Classifier<T, ItemWriter<? super T>> classifier) {
        Assert.notNull(classifier, (String)"A classifier is required.");
        this.classifier = classifier;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        LinkedHashMap<ItemWriter, Chunk<Object>> map = new LinkedHashMap<ItemWriter, Chunk<Object>>();
        for (Object item : items) {
            ItemWriter key = (ItemWriter)this.classifier.classify(item);
            if (!map.containsKey(key)) {
                map.put(key, new Chunk<Object>(new Object[0]));
            }
            ((Chunk)map.get(key)).add(item);
        }
        for (ItemWriter writer : map.keySet()) {
            writer.write((Chunk)map.get(writer));
        }
    }
}

