/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import org.springframework.batch.repeat.RepeatContext;

public final class RepeatSynchronizationManager {
    private static final ThreadLocal<RepeatContext> contextHolder = new ThreadLocal();

    private RepeatSynchronizationManager() {
    }

    public static RepeatContext getContext() {
        return contextHolder.get();
    }

    public static void setCompleteOnly() {
        RepeatContext context = RepeatSynchronizationManager.getContext();
        if (context != null) {
            context.setCompleteOnly();
        }
    }

    public static RepeatContext register(RepeatContext context) {
        RepeatContext oldSession = RepeatSynchronizationManager.getContext();
        contextHolder.set(context);
        return oldSession;
    }

    public static RepeatContext clear() {
        RepeatContext context = RepeatSynchronizationManager.getContext();
        contextHolder.remove();
        return context;
    }

    public static void setAncestorsCompleteOnly() {
        for (RepeatContext context = RepeatSynchronizationManager.getContext(); context != null; context = context.getParent()) {
            context.setCompleteOnly();
        }
    }
}

