/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.batch.infrastructure.repeat.RepeatException;
import org.springframework.batch.infrastructure.repeat.RepeatOperations;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

public class RepeatOperationsInterceptor
implements MethodInterceptor {
    private RepeatOperations repeatOperations = new RepeatTemplate();

    public void setRepeatOperations(RepeatOperations batchTemplate) {
        Assert.notNull((Object)batchTemplate, (String)"'repeatOperations' cannot be null.");
        this.repeatOperations = batchTemplate;
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        ResultHolder result = new ResultHolder();
        boolean voidReturnType = Void.TYPE.equals(invocation.getMethod().getReturnType());
        if (voidReturnType) {
            result.setValue(new Object());
        }
        this.repeatOperations.iterate(context -> {
            try {
                if (!(invocation instanceof ProxyMethodInvocation)) {
                    throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
                }
                ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation)invocation;
                MethodInvocation clone = proxyMethodInvocation.invocableClone();
                Object value = clone.proceed();
                if (voidReturnType) {
                    return RepeatStatus.CONTINUABLE;
                }
                if (!this.isComplete(value)) {
                    result.setValue(value);
                    return RepeatStatus.CONTINUABLE;
                }
                result.setFinalValue(value);
                return RepeatStatus.FINISHED;
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    Exception e = (Exception)t;
                    throw e;
                }
                throw new RepeatOperationsInterceptorException("Unexpected error in batch interceptor", t);
            }
        });
        if (result.isReady()) {
            return result.getValue();
        }
        throw new IllegalStateException("No result available for attempted repeat call to " + String.valueOf(invocation) + ".  The invocation was never called, so maybe there is a problem with the completion policy?");
    }

    private boolean isComplete(@Nullable Object result) {
        Boolean b;
        return result == null || result instanceof Boolean && (b = (Boolean)result) == false;
    }

    private static class ResultHolder {
        private @Nullable Object value;
        private boolean ready = false;

        private ResultHolder() {
        }

        public void setValue(@Nullable Object value) {
            this.ready = true;
            this.value = value;
        }

        public void setFinalValue(@Nullable Object value) {
            if (this.ready) {
                return;
            }
            this.setValue(value);
        }

        public @Nullable Object getValue() {
            return this.value;
        }

        public boolean isReady() {
            return this.ready;
        }
    }

    private static class RepeatOperationsInterceptorException
    extends RepeatException {
        public RepeatOperationsInterceptorException(String message, Throwable e) {
            super(message, e);
        }
    }
}

