/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.container.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;

public class BatchMessageListenerContainer
extends DefaultMessageListenerContainer {
    private RepeatOperations template;
    private ThreadLocal messageHolder = new ThreadLocal();

    public BatchMessageListenerContainer(RepeatOperations template) {
        this.template = template;
        this.setAutoStartup(false);
        this.setMessageListener(new MessageListenerAdapter());
    }

    protected Message receiveMessage(MessageConsumer consumer) throws JMSException {
        Message message = super.receiveMessage(consumer);
        if (message != null) {
            this.messageHolder.set(message);
        }
        return message;
    }

    protected void rollbackOnExceptionIfNecessary(Session session, Throwable ex) throws JMSException {
        super.rollbackOnExceptionIfNecessary(session, ex);
        if (session.getTransacted() && this.isSessionTransacted()) {
            this.messageHolder.set(null);
        }
    }

    protected void doExecuteListener(Session session, Message message) throws JMSException {
        try {
            super.doExecuteListener(session, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(session, message, ex);
        }
    }

    protected void recover(Session session, Message message, Throwable ex) throws JMSException {
    }

    protected final void handleListenerException(Session session, Message message, Throwable ex) throws JMSException {
        this.recover(session, message, ex);
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
    }

    protected boolean receiveAndExecute(final Session session, final MessageConsumer consumer) throws JMSException {
        this.template.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                return BatchMessageListenerContainer.this.doBatchCallBack(session, consumer);
            }
        });
        if (this.messageHolder.get() == null) {
            return false;
        }
        this.messageHolder.set(null);
        return true;
    }

    protected ExitStatus doBatchCallBack(Session session, MessageConsumer consumer) throws JMSException {
        if (super.receiveAndExecute(session, consumer)) {
            Object message = this.messageHolder.get();
            return new ExitStatus(message != null);
        }
        return ExitStatus.FINISHED;
    }
}

