/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import java.io.Serializable;
import org.springframework.batch.core.StepContribution;

public class ChunkResponse
implements Serializable {
    private final StepContribution stepContribution;
    private final Long jobId;
    private final boolean status;
    private final String message;
    private final boolean redelivered;
    private final int sequence;

    public ChunkResponse(int sequence, Long jobId, StepContribution stepContribution) {
        this(true, sequence, jobId, stepContribution, null);
    }

    public ChunkResponse(boolean status, int sequence, Long jobId, StepContribution stepContribution) {
        this(status, sequence, jobId, stepContribution, null);
    }

    public ChunkResponse(boolean status, int sequence, Long jobId, StepContribution stepContribution, String message) {
        this(status, sequence, jobId, stepContribution, message, false);
    }

    public ChunkResponse(ChunkResponse input, boolean redelivered) {
        this(input.status, input.sequence, input.jobId, input.stepContribution, input.message, redelivered);
    }

    public ChunkResponse(boolean status, int sequence, Long jobId, StepContribution stepContribution, String message, boolean redelivered) {
        this.status = status;
        this.sequence = sequence;
        this.jobId = jobId;
        this.stepContribution = stepContribution;
        this.message = message;
        this.redelivered = redelivered;
    }

    public StepContribution getStepContribution() {
        return this.stepContribution;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean isSuccessful() {
        return this.status;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": jobId=" + this.jobId + ", sequence=" + this.sequence + ", stepContribution=" + this.stepContribution + ", successful=" + this.status;
    }
}

