/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class StepExecutionInterceptor
implements ChannelInterceptor {
    public static final String STEP_EXECUTION = "stepExecution";

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            return message;
        }
        return ((MessageBuilder)MessageBuilder.fromMessage(message).setHeader(STEP_EXECUTION, (Object)context.getStepExecution())).build();
    }
}

