/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.Collection;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.support.PropertiesConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataInstanceFactory {
    public static JobInstance createJobInstance(String jobName, Long instanceId, String jobParameters) {
        JobParameters params = new DefaultJobParametersConverter().getJobParameters(PropertiesConverter.stringToProperties((String)jobParameters));
        return MetaDataInstanceFactory.createJobInstance(jobName, instanceId, params);
    }

    public static JobInstance createJobInstance(String jobName, Long instanceId, JobParameters jobParameters) {
        return new JobInstance(instanceId, jobParameters, jobName);
    }

    public static JobInstance createJobInstance(String jobName, Long instanceId) {
        return new JobInstance(instanceId, new JobParameters(), jobName);
    }

    public static JobInstance createJobInstance() {
        return new JobInstance(Long.valueOf(12L), new JobParameters(), "job");
    }

    public static JobExecution createJobExecution() {
        return MetaDataInstanceFactory.createJobExecution(123L);
    }

    public static JobExecution createJobExecution(Long executionId) {
        return MetaDataInstanceFactory.createJobExecution("job", 12L, executionId);
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId) {
        return MetaDataInstanceFactory.createJobExecution(jobName, instanceId, executionId, new JobParameters());
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId, String jobParameters) {
        JobParameters params = new DefaultJobParametersConverter().getJobParameters(PropertiesConverter.stringToProperties((String)jobParameters));
        return MetaDataInstanceFactory.createJobExecution(jobName, instanceId, executionId, params);
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId, JobParameters jobParameters) {
        return new JobExecution(MetaDataInstanceFactory.createJobInstance(jobName, instanceId, jobParameters), executionId);
    }

    public static StepExecution createStepExecution() {
        return MetaDataInstanceFactory.createStepExecution("step", 1234L);
    }

    public static StepExecution createStepExecution(String stepName, Long executionId) {
        return MetaDataInstanceFactory.createStepExecution(MetaDataInstanceFactory.createJobExecution(), stepName, executionId);
    }

    public static StepExecution createStepExecution(JobExecution jobExecution, String stepName, Long executionId) {
        StepExecution stepExecution = jobExecution.createStepExecution(stepName);
        stepExecution.setId(executionId);
        return stepExecution;
    }

    public static JobExecution createJobExecutionWithStepExecutions(Long executionId, Collection<String> stepNames) {
        JobExecution jobExecution = MetaDataInstanceFactory.createJobExecution("job", 12L, executionId);
        Long stepExecutionId = 1234L;
        for (String stepName : stepNames) {
            MetaDataInstanceFactory.createStepExecution(jobExecution, stepName, stepExecutionId);
            Long l = stepExecutionId;
            Long l2 = stepExecutionId = Long.valueOf(stepExecutionId + 1L);
        }
        return jobExecution;
    }
}

