/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.jvm.Jvm;
import org.springframework.boot.experimental.gradle.PomTask;
import org.springframework.boot.experimental.gradle.PropertiesTask;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.util.StringUtils;

public class ThinLauncherPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        boolean hasBootRepackage;
        boolean bl = hasBootRepackage = project.getTasks().findByName("bootRepackage") != null;
        if (!hasBootRepackage) {
            this.createThinJarTask(project);
        }
        this.createPropertiesTask(project);
        this.createPomTask(project);
        project.getTasks().withType(Jar.class, (Action)new Action<Jar>(){

            public void execute(Jar jar) {
                String name = jar.getName();
                if (!name.equals("thinJar")) {
                    String suffix;
                    String string = suffix = "jar".equals(name) || "bootJar".equals(name) ? "" : StringUtils.capitalize((String)name);
                    if (project.getTasksByName("thinResolve" + suffix, true).isEmpty()) {
                        Task thinResolvePrepare = ThinLauncherPlugin.this.createResolvePrepareTask(project, suffix);
                        Task thinResolveTask = ThinLauncherPlugin.this.createResolveTask(project, suffix);
                        if (hasBootRepackage) {
                            Task bootRepackage = project.getTasks().getByName("bootRepackage");
                            thinResolvePrepare.dependsOn(new Object[]{bootRepackage});
                        } else {
                            Task thinJar = project.getTasks().getByName("thinJar");
                            thinResolvePrepare.dependsOn(new Object[]{thinJar});
                        }
                        thinResolveTask.dependsOn(new Object[]{thinResolvePrepare});
                    }
                }
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Task jarTask = project.getTasks().findByName("bootJar") != null ? project.getTasks().getByName("bootJar") : project.getTasks().getByName("jar");
                if (!hasBootRepackage) {
                    Task thinJar = project.getTasks().getByName("thinJar");
                    thinJar.dependsOn(new Object[]{jarTask});
                    project.getTasks().getByName("assemble").dependsOn(new Object[]{thinJar});
                }
            }
        });
    }

    private Task createThinJarTask(final Project project) {
        return ((Jar)project.getTasks().create("thinJar", Jar.class)).doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Jar thinJar = (Jar)task;
                Jar bootJar = project.getTasks().findByName("bootJar") != null ? (Jar)project.getTasks().getByName("bootJar") : (Jar)project.getTasks().getByName("jar");
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("Main-Class", "org.springframework.boot.loader.wrapper.ThinJarWrapper");
                attrs.put("Start-Class", this.getMainClass(bootJar));
                thinJar.getManifest().attributes(attrs);
                thinJar.from(new Object[]{project.zipTree((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File file = File.createTempFile("tmp", ".jar", project.getBuildDir());
                        file.delete();
                        Files.copy(this.getClass().getClassLoader().getResourceAsStream("META-INF/loader/spring-boot-thin-wrapper.jar"), file.toPath(), new CopyOption[0]);
                        return file;
                    }
                })});
                SourceSet sources = (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
                thinJar.from(new Object[]{sources.getRuntimeClasspath().filter((Spec)new Spec<File>(){

                    public boolean isSatisfiedBy(File element) {
                        return element.isDirectory();
                    }
                }).getFiles().toArray(new File[0])});
                thinJar.from(new Object[]{ThinLauncherPlugin.this.getThinPomDirectory(project)});
            }

            private Object getMainClass(Jar bootJar) {
                Object result = bootJar.getManifest().getAttributes().get((Object)"Start-Class");
                if (result != null) {
                    return result;
                }
                result = bootJar.getManifest().getAttributes().get((Object)"Main-Class");
                if (result != null) {
                    return result;
                }
                File root = bootJar.getArchivePath();
                try {
                    return MainClassFinder.findSingleMainClass((java.util.jar.JarFile)new JarFile(root), (String)"");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot locate main class in " + root, e);
                }
            }
        });
    }

    private Task createPomTask(final Project project) {
        Task result = ((PomTask)project.getTasks().create("thinPom", PomTask.class, (Action)new Action<PomTask>(){

            public void execute(final PomTask thin) {
                project.getTasks().withType(Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar jar) {
                        jar.dependsOn(new Object[]{thin});
                    }
                });
            }
        })).doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                PomTask thin = (PomTask)task;
                thin.setOutput(new File(ThinLauncherPlugin.this.getThinPomDirectory(project), "META-INF/maven/" + project.getGroup() + "/" + project.getName()));
            }
        });
        return result;
    }

    private File getThinPomDirectory(Project project) {
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        File resourcesDir = new File(((SourceSet)sourceSets.getByName("main")).getOutput().getResourcesDir(), "../thinPom").getAbsoluteFile();
        return resourcesDir;
    }

    private Task createPropertiesTask(final Project project) {
        return ((PropertiesTask)project.getTasks().create("thinProperties", PropertiesTask.class)).doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                PropertiesTask libPropertiesTask = (PropertiesTask)task;
                ThinLauncherPlugin.this.configureLibPropertiesTask(libPropertiesTask, project);
            }
        });
    }

    private void configureLibPropertiesTask(PropertiesTask thin, Project project) {
        thin.setConfiguration(this.findRuntimeClasspath(project));
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        File resourcesDir = ((SourceSet)sourceSets.getByName("main")).getOutput().getResourcesDir();
        thin.setOutput(new File(resourcesDir, "META-INF"));
    }

    private Configuration findRuntimeClasspath(Project project) {
        Configuration configuration = project.getConfigurations().getByName("runtimeClasspath");
        if (configuration == null) {
            configuration = project.getConfigurations().getByName("runtime");
        }
        return configuration;
    }

    private Task createResolvePrepareTask(final Project project, String suffix) {
        return ((Copy)project.getTasks().create("thinResolvePrepare" + suffix, Copy.class, (Action)new Action<Copy>(){

            public void execute(Copy copy) {
                Jar thinJar = project.getTasks().findByName("thinJar") != null ? (Jar)project.getTasks().getByName("thinJar") : (Jar)project.getTasks().getByName("jar");
                copy.from(new Object[]{thinJar.getOutputs().getFiles()});
                copy.into((Object)new File(project.getBuildDir(), "thin/root"));
            }
        })).doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                try {
                    File wrapper = new File(project.getBuildDir(), "thin/spring-boot-thin-wrapper.jar");
                    if (!wrapper.exists()) {
                        wrapper.getParentFile().mkdirs();
                        Files.copy(this.getClass().getClassLoader().getResourceAsStream("META-INF/loader/spring-boot-thin-wrapper.jar"), wrapper.toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot copy thin jar wrapper", e);
                }
            }
        });
    }

    private Task createResolveTask(final Project project, final String suffix) {
        return ((Exec)project.getTasks().create("thinResolve" + suffix, Exec.class)).doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Exec exec = (Exec)task;
                Jar thinJar = project.getTasks().findByName("thinJar") != null ? (Jar)project.getTasks().getByName("thinJar") : (Jar)project.getTasks().getByName("jar");
                String prepareTask = "thinResolvePrepare" + suffix;
                Copy copy = (Copy)project.getTasks().getByName(prepareTask);
                exec.setWorkingDir((Object)copy.getOutputs().getFiles().getSingleFile());
                exec.setCommandLine(new Object[]{Jvm.current().getJavaExecutable()});
                ArrayList<String> args = new ArrayList<String>(Arrays.asList("-Dthin.root=.", "-Dthin.dryrun", "-jar", "../spring-boot-thin-wrapper.jar"));
                args.add(1, "-Dthin.archive=" + thinJar.getArchivePath());
                String thinRepo = ThinLauncherPlugin.this.getThinRepo(project);
                if (thinRepo != null) {
                    args.add(1, "-Dthin.repo=" + thinRepo);
                }
                exec.args(args);
            }
        });
    }

    private String getThinRepo(Project project) {
        if (System.getProperty("thin.repo") != null) {
            return System.getProperty("thin.repo");
        }
        if (System.getenv("THIN_REPO") != null) {
            return System.getProperty("THIN_REPO");
        }
        Map properties = project.getProperties();
        if (properties != null && properties.get("thin.repo") != null) {
            return (String)properties.get("thin.repo");
        }
        return null;
    }
}

