/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.apache.maven.model.locator.ModelLocator;
import org.apache.maven.model.validation.DefaultModelValidator;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.springframework.boot.loader.thin.ThinPropertiesModelProcessor;

class DependencyResolutionModule
extends AbstractModule {
    DependencyResolutionModule() {
    }

    protected void configure() {
        this.bind(ModelProcessor.class).to(ThinPropertiesModelProcessor.class).in(Singleton.class);
        this.bind(ModelLocator.class).to(DefaultModelLocator.class).in(Singleton.class);
        this.bind(ModelReader.class).to(DefaultModelReader.class).in(Singleton.class);
        this.bind(ModelValidator.class).to(DefaultModelValidator.class).in(Singleton.class);
        this.bind(RepositoryConnectorFactory.class).to(BasicRepositoryConnectorFactory.class).in(Singleton.class);
        this.bind(TransporterFactory.class).annotatedWith((Annotation)Names.named((String)"http")).to(HttpTransporterFactory.class).in(Singleton.class);
        this.bind(TransporterFactory.class).annotatedWith((Annotation)Names.named((String)"file")).to(HttpTransporterFactory.class).in(Singleton.class);
        this.bind(ArtifactDescriptorReader.class).to(DefaultArtifactDescriptorReader.class).in(Singleton.class);
        this.bind(VersionResolver.class).to(DefaultVersionResolver.class).in(Singleton.class);
        this.bind(VersionRangeResolver.class).to(DefaultVersionRangeResolver.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith((Annotation)Names.named((String)"snapshot")).to(SnapshotMetadataGeneratorFactory.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith((Annotation)Names.named((String)"versions")).to(VersionsMetadataGeneratorFactory.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    Set<MetadataGeneratorFactory> provideMetadataGeneratorFactories(@Named(value="snapshot") MetadataGeneratorFactory snapshot, @Named(value="versions") MetadataGeneratorFactory versions) {
        HashSet<MetadataGeneratorFactory> factories = new HashSet<MetadataGeneratorFactory>();
        factories.add(snapshot);
        factories.add(versions);
        return Collections.unmodifiableSet(factories);
    }

    @Provides
    @Singleton
    Set<RepositoryConnectorFactory> provideRepositoryConnectorFactories(RepositoryConnectorFactory factory) {
        return Collections.singleton(factory);
    }

    @Provides
    @Singleton
    Set<TransporterFactory> provideTransporterFactories(@Named(value="http") TransporterFactory file, @Named(value="file") TransporterFactory http) {
        HashSet<TransporterFactory> factories = new HashSet<TransporterFactory>();
        factories.add(file);
        factories.add(file);
        return Collections.unmodifiableSet(factories);
    }
}

